C
C------------------------------------------------------
C
C     Problem:    SLAB
C
C     Date:       4.07.1996
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      T0 = 0.2
      Tf = 1.2 
      rho0 = 1 
      phi = 4 
      beta = 1
C
C------------------------------------------------------
C       
*     SET OF INDICES
      ind = 1..4
C
C------------------------------------------------------
C    
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      A1, A2, C, T, rho, sigma, T_x, rho_x, sigma_x
      T_xx, rho_xx, sigma_xx, x, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_t 
      T_t = T_xx + (A1*1.0E+5*rho + A2*1.0E+10*sigma)
     /                           *beta/(1+beta)*exp(-phi/T)
C
*     FUNCTION rho_t
      rho_t = rho_xx - A1*1.0E+5*rho*exp(-phi/T)
C
*     FUNCTION sigma_t 
      sigma_t = sigma_xx + (A1*1.0E+5*rho - A2*1.0E+10*sigma)
     /                           *exp(-phi/T)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_0
      T_0 = T0
C
*     FUNCTION rho_0
      rho_0 = rho0
C
*     FUNCTION sigma_0
      sigma_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION T_right
      T1 = T0 + C*1000*time
      if (T1.le.Tf) then
        T_right = T1
      else
        T_right = Tf
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C
*     FUNCTION T_x_left
      T_x_left = 0
C
*     FUNCTION rho_x_left
      rho_x_left = 0
C
*     FUNCTION sigma_x_left
      sigma_x_left = 0
C
*     FUNCTION rho_x_right
      rho_x_right = 0
C
*     FUNCTION sigma_x_right
      sigma_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


