C
C------------------------------------------------------
C
C     Problem:    SKIN_D
C
C     Date:       19.04.1994
C
C------------------------------------------------------
C
*     INTEGER CONSTANT
      N=15
      NM1=N-1
      NM2=N-2
C
C------------------------------------------------------
C
*     INDEX 
      j
C
C------------------------------------------------------
C
*     REAL CONSTANT
      VA=3000.0
      FA=63.6
      KM=7.0D-3
      Y0=326.6
      L=0.01
      H=L/(N-1)
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDU = 1..N
      INDU1= 1..NM1
      INDU2= 1..NM2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ds, Dm, Ps, Pm, VMAX
      Us(i), i IN INDU
      Um(i), i IN INDU
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION UsP1
      UsP1=Ps/(VA*H)*FA*Ds*(Us(2) - Us(1))
C
*     FUNCTION UsP(i), i IN INDU2
      j=i+1
      UsP(i)=Ds*(Us(j+1) - 2*Us(j) + Us(j-1))/H**2 
     /     - VMAX*Us(j)/(KM + Us(j))
C
*     FUNCTION UsPN
      j=N
      UsPN=-Ps/(VA*H)*FA*Ds*(Us(j) - Us(j-1))       
C
*     FUNCTION UmP1
      UmP1=Pm/(VA*H)*FA*Dm*(Um(2) - Um(1))
C
*     FUNCTION UmP(i), i IN INDU2
      j=i+1
      UmP(i)=Dm*(Um(j+1) - 2*Um(j) + Um(j-1))/H**2 
     /     + VMAX*Us(j)/(KM + Us(j))
C
*     FUNCTION UmPN
      j=N
      UmPN=-Pm/(VA*H)*FA*Dm*(Um(j) - Um(j-1))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Us01
      Us01=Y0*Ps/VA
C
*     FUNCTION Us0(i), i IN INDU1
      Us0(i)=0
C
*     FUNCTION Um01
      Um01=0
C
*     FUNCTION Um0(i), i IN INDU1
      Um0(i)=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION UsFIT1
      UsFIT1=Us(1)*VA/Ps
C
*     FUNCTION UmFIT1
      UmFIT1=Um(1)*VA/Pm
C
*     FUNCTION UsFITn
      J=N
      UsFITn=Us(J)*VA/Ps
C
*     FUNCTION UmFITn
      j=N
      UmFITn=Um(j)*VA/Pm
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

