C
C------------------------------------------------------
C
C     Problem:    SKIN4
C
C     Date:       10.06.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Km = 7.0D-3
      Va = 3.0E+03
      Fa = 63.6
      L  = 0.01
      Y0 = 300.0
      Ps = 0.001
      Pm = 0.8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Ds, Dm, Vmax
      u1, u2, u1_x, u2_x, u1_xx, u2_xx
      v1, v2, v3, v4, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_p
      u1_p = Ds*u1_xx - Vmax*u1/(Km + u1)
C
*     FUNCTION u2_p
      u2_p = Dm*u2_xx + Vmax*u1/(Km + u1)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u10
      u10 = 0.0
C
*     FUNCTION u20
      u20 = 0.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION v1_p
      v1_p = Fa*Ds*u1_x
C
*     FUNCTION v2_p
      v2_p = Fa*Dm*u2_x
C
*     FUNCTION v3_p
      v3_p = -Fa*Ds*u1_x
C
*     FUNCTION v4_p
      v4_p = -Fa*Dm*u2_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION v10
      v10 = Y0
C
*     FUNCTION v20
      v20 = 0
C
*     FUNCTION v30
      v30 = 0
C
*     FUNCTION v40
      v40 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
*     FUNCTION L11
      L11 = Ps/Va*v1
C
*     FUNCTION L12
      L12 = Pm/Va*v2
C
*     FUNCTION R21
      R21 = Ps/Va*v3
C
*     FUNCTION R22
      R22 = Pm/Va*v4
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = v1
C
*     FUNCTION FIT2
      FIT2 = v2
C
*     FUNCTION FIT3
      FIT3 = v3
C
*     FUNCTION FIT4
      FIT4 = v4
C
*     FUNCTION balance
      balance = (v1 + v2 + v3 + v4 - Y0
     /   + Fa*(simpsn(1,1)+ simpsn(2,1)))/Y0

C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
