C
C------------------------------------------------------
C
C     Problem:    SKIN3
C
C     Date:       20.12.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Va = 3000.0
      Vd = 3000.0
      Fd = 63.6
      Fa = 63.6
      Y0 = 1450.0
      Pm = 1
      Ds = 0.013
      Dm = 0.013   
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      Ps, Vmax, Km
      Us, Um, Us_x, Um_x, Us_xx, Um_xx
      Y, Qmd, Qsa, Qma
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Us_t
      Us_t = Ds*Us_xx - Vmax*Us/(Km + Us) 
C
*     FUNCTION Um_t
      Um_t = Dm*Um_xx + Vmax*Us/(Km + Us)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Us_0
      Us_0 = 0.0
C
*     FUNCTION Um_0
      Um_0 = 0.0     
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C 
*     FUNCTION Y_t
      Y_t = Fd*Ds*Us_x
C
*     FUNCTION Qmd_t
      Qmd_t = Fd*Dm*Um_x
C 
*     FUNCTION Qsa_t
      Qsa_t = -Fa*Ds*Us_x
C 
*     FUNCTION Qma_t
      Qma_t = -Fa*Dm*Um_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION Y_0
      Y_0 = Y0
C
*     FUNCTION Qmd_0
      Qmd_0 = 0.0
C
*     FUNCTION Qsa_0
      Qsa_0 = 0.0
C
*     FUNCTION Qma_0
      Qma_0 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION L11
      L11 = Y*Ps/Vd
C
*     FUNCTION L12
      L12 = 0 
C
*     FUNCTION R1
      R1 = 0
C
*     FUNCTION R2
      R2 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
C*     FUNCTION RX11
C      RX11 = ...
C
C*     FUNCTION RX12
C      RX12 = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = Y
C
*     FUNCTION FIT2
      FIT2 = Qmd
C
*     FUNCTION FIT3
      FIT3 = Qsa
C
*     FUNCTION FIT4
      FIT4 = Qma
C
*     FUNCTION balance
      balance = (Y + Qmd + Qsa + Qma - Y0
     /         + Fd*SIMPSN(1,1) + Fa*SIMPSN(2,1))/Y0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

