C
C------------------------------------------------------
C
C     Problem:  SKIN2
C
C     Date:     26.09.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      VA = 3000
      FA = 63.6
      Y0 = 324
      X3 = 0.011
      KP2 = 0.0001
      KM2 = 0.01 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D1, D2, D3, PS, PM, R0, KP1, KM1
      U1, U2, U3, UX1, UX2, UX3, UXX1, UXX2, UXX3
      VL1, VL2, VL3, VR1, VR2, VR3
      X, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION U1P
      F13 = KP1*(R0 - U2 - U3)*U1 - KM1*U3
      U1P = D1*UXX1 - F13
C 
*     FUNCTION U2P
      F23 = -KP2*(R0 - U2 - U3)*U2 + KM2*U3
      U2P = D2*UXX2 + F23
C
*     FUNCTION U3P
      U3P = D3*UXX3 + F13 - F23    
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION U10
      IF (X.EQ.0.0) THEN
        U10 = Y0*PS/VA
      ELSE
        U10 = 0.0
      ENDIF
C
*     FUNCTION U20
      U20 = 0.0
C
*     FUNCTION U30
      U30 = 0.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION V1LP
      V1LP = FA*D1*UX1
C 
*     FUNCTION V2LP
      V2LP = FA*D2*UX2
C 
*     FUNCTION V3LP
      V3LP = FA*D3*UX3
C
*     FUNCTION V1RP
      V1RP = -FA*D1*UX1
C
*     FUNCTION V2RP
      V2RP = -FA*D2*UX2
C
*     FUNCTION V3RP
      V3RP = -FA*D3*UX3
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION V1L0
      V1L0 = Y0
C
*     FUNCTION V2L0
      V2L0 = 0.0
C
*     FUNCTION V3L0
      V3L0 = 0.0
C
*     FUNCTION V1R0
      V1R0 = 0.0
C
*     FUNCTION V2R0
      V2R0 = 0.0
C
*     FUNCTION V3R0
      V3R0 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION L1
      L1 = VL1*PS/VA
C
*     FUNCTION L2
      L2 = VL2*PM/VA
C
*     FUNCTION L3
      L3 = VL3*PS/VA
C
*     FUNCTION R1
      R1 = VR1*PS/VA
C
*     FUNCTION R2
      R2 = VR2*PM/VA
C
*     FUNCTION R3
      R3 = VR3*PS/VA
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FIT1
      FIT1 = VL1
C
*     FUNCTION FIT2
      FIT2 = VL2 + VL3
C
*     FUNCTION FIT3
      FIT3 = VR1
C
*     FUNCTION FIT4
      FIT4 = VR2 + VR3
C
*     FUNCTION BALANCE
      BALANCE = (VL1 + VL2 + VL3 + VR1 + Vr2 + VR3 - Y0
     /   + FA*X3*(simpsn(1,1)+ simpsn(2,1)+simpsn(3,1)))/Y0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


