C
C------------------------------------------------------
C
C     Problem:    SKIN1
C
C     Date:       22.5.2007
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Km   = 7.0E-3
      L    = 0.01   
      Fa   = 63.6
      Va   = 3000 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each DE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Ds1, Dm1, Ds2, Dm2, Ps, Pm, Vmax, Ts, Tm, Y0
      U1, U2, Ux1, Ux2, Uxx1, Uxx2
      V1, V2, V3, V4, X, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION U11P
      U11P = Ds1*Uxx1 - Vmax*U1/(Km+U1)
C
*     FUNCTION U12P
      U12P = Dm1*Uxx2 + Vmax*U1/(Km+U1)
C
*     FUNCTION U21P
      U21P = Ds2*Uxx1
C
*     FUNCTION U22P
      U22P = Dm2*Uxx2
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION U110
      IF (X.EQ.0) THEN
        U110 = Y0*Ps/Va        
      ELSE
        U110 = 0
      ENDIF
C
*     FUNCTION U120
      U120 = 0
C
*     FUNCTION U210
      U210 = 0
C
*     FUNCTION U220
      U220 = 0
C 
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION V1P
      V1P = Fa*Ds1*Ux1
C
*     FUNCTION V2P
      V2P = Fa*Dm1*Ux2
C
*     FUNCTION V3P
      V3P = -Fa*Ds2*Ux1
C
*     FUNCTION V4P
      V4P = -Fa*Dm2*Ux2
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION V10
      V10 = Y0
C
*     FUNCTION V20
      V20 = 0.0
C
*     FUNCTION V30
      V30 = 0.0
C
*     FUNCTION V40
      V40 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
*     FUNCTION L11
      L11 = Ps/Va*V1
C
*     FUNCTION L12
c      L12 = 0       
      L12 = Pm/Va*V2
C
*     FUNCTION L21
      L21 = Ts*U1
C
*     FUNCTION L22
      L22 = Tm*U2
C
*     FUNCTION R21
c      R21 = 0
      R21 = Ps/Va*V3 
C
*     FUNCTION R22
c      R22 = 0        
      R22 = Pm/Va*V4
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION RX11
      RX11 = Ds2/Ds1*Ux1
C
*     FUNCTION RX12
      RX12 = Dm2/Dm1*Ux2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = V1
C
*     FUNCTION FIT2
      FIT2 = V2
C
*     FUNCTION FIT3
      FIT3 = V3
C
*     FUNCTION FIT4
      FIT4 = V4
C
*     FUNCTION BALANCE
      balance = (V1 + V2 + V3 + V4 - Y0
     /         + Fa*SIMPSN(1,1) + Fa*SIMPSN(2,1))/Y0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



