C
C------------------------------------------------------
C
C     Problem:     SING_EQU
C
C     Date:        10.03.2004
C
C------------------------------------------------------
C             
*     SET OF INDICES
      ind = 1..8       
C
C------------------------------------------------------
C             
*     REAL CONSTANT
      A = 0.5
      hA = 1
      Rs = 28
      m = 100  
      T = 12
C
C------------------------------------------------------
C                    
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      lambda, h, RT, R0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g   
      RT1 = RT              
      if (RT.le.0) then
         RT1=1E-5
      endif   
      g = log(RT1/R0)*(1 + A*hA*lambda)/lambda + h*(RT1 - R0)
     /    - hA*A/m*log((Rs**m + RT1**m)/(Rs*m + R0**m)) + T
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION y_0
      y_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = RT
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION c(i), i in ind
      c(i) = RT
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
