C
C------------------------------------------------------
C
C     Problem:    SILICON
C
C     Date:       11.05.1998
C
C------------------------------------------------------
C
*     REAL CONSTANT
      q = 1.602E-5
      kT = 0.0259*q
      Na = 2.0E1
      eps = 11.9*8.85418
      Cu0 = 2
      V0  = 0.005
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, Cu, V, Cu_x, V_x, Cu_xx, V_xx, fCu, fV, fCu_x, fV_x,
     /      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION fluxCu
      fluxCu = D*Cu_x + q/kT*Cu*V_x
C
*     FUNCTION fluxV
      fluxV = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Cu_t
      Cu_t = fCu_x
C
*     FUNCTION V_equ
c      V_equ = (V_xx*1.0E-14 + q/eps*(Cu - Na*1.0E-14*(1 - 
c     /    exp(-q*V/kT))))*1.0E-15
      V_equ = (V_xx + q/eps*(Cu - Na*(1-exp(-q*V/kT))))
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Cu_0
      Cu_0 = Cu0
C
*     FUNCTION V_0
      V_0 = V0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Cu_left
      Cu_left = 0
C
*     FUNCTION V_left
      V_left = V0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C
*     FUNCTION C_x_right
      Cu_x_right = 0
C
*     FUNCTION V_x_right
      V_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_Cu
      fit_Cu = Cu
C
*     FUNCTION fit_V
      fit_V = V
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

