C
C------------------------------------------------------
C
C     Problem:    SHOCK
C
C     Date:       06.07.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      DCJ = 6.788
      D01 = 6.156
      Z01 = 17.5
      D02 = 5.835
      Z02 = 8.4
      D03 = 4.044
      Z03 = 3.3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      A1, NUE, A2, PSI
      PHI1, PHI2, PHI3
      Z1, Z2, Z3
      KAPPA1, KAPPA2, KAPPA3
      R
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION DPHI1
      if (R.gt.0) then
        DPHI1 = -DTAN(PHI1)/R + KAPPA1/DCOS(PHI1)
      else
        DPHI1 = 0
      endif
C
*     FUNCTION DPHI2
      if (R.gt.0) then
        DPHI2 = -DTAN(PHI2)/R + KAPPA2/DCOS(PHI2)
      else
        DPHI2 = 0
      endif
C
*     FUNCTION DPHI3
      if (R.gt.0) then
        DPHI3 = -DTAN(PHI3)/R + KAPPA3/DCOS(PHI3)
      else
        DPHI3 = 0
      endif
C
*     FUNCTION DZ1
      DZ1 = -DTAN(PHI1)
C
*     FUNCTION DZ2
      DZ2 = -DTAN(PHI2)
C
*     FUNCTION DZ3
      DZ3 = -DTAN(PHI3)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION ALGE1
      ALGE1 = D01*DCOS(PHI1)/DCJ + A1*KAPPA1**(1.0/NUE) + 
     /     A2*KAPPA1*DEXP(PSI*(DCJ-D01*DCOS(PHI1))) - 1.0
C
*     FUNCTION ALGE2
      ALGE2 = D02*DCOS(PHI2)/DCJ + A1*KAPPA2**(1.0/NUE) + 
     /     A2*KAPPA2*DEXP(PSI*(DCJ-D02*DCOS(PHI2))) - 1.0
C
*     FUNCTION ALGE3
      ALGE3 = D03*DCOS(PHI3)/DCJ + A1*KAPPA3**(1.0/NUE) + 
     /     A2*KAPPA3*DEXP(PSI*(DCJ-D03*DCOS(PHI3))) - 1.0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PHI01
      PHI01 = 0.0
C
*     FUNCTION PHI02
      PHI02 = 0.0
C
*     FUNCTION PHI03
      PHI03 = 0.0
C
*     FUNCTION Z001
      Z001 = Z01
C
*     FUNCTION Z002
      Z002 = Z02
C
*     FUNCTION Z003
      Z003 = Z03
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION KAPPA01
      KAPPA01 = 0.0005
C
*     FUNCTION KAPPA02
      KAPPA02 = 0.0005
C
*     FUNCTION KAPPA03
      KAPPA03 = 0.0005
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ZFIT1
      ZFIT1 = Z1
C
*     FUNCTION ZFIT2
      ZFIT2 = Z2
C
*     FUNCTION ZFIT3
      ZFIT3 = Z3
C
*     FUNCTION PHIFIT1
      PHIFIT1 = PHI1
C
*     FUNCTION PHIFIT2
      PHIFIT2 = PHI2
C
*     FUNCTION PHIFIT3
      PHIFIT3 = PHI3
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

