C
C------------------------------------------------------
C
C     Problem:    SHELL
C
C     Date:       17.07.1993
C
C------------------------------------------------------
C
*     REAL CONSTANT
      P7  = 1.0D+5
      P8  = 1.0D+3
      P9  = 7.0D+4
      P10 = 14.0D+2
      P11 = 7.0D+3
      P12 = 14.0D+3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      P1, P2, P3, P4, P5, P6
      Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = -P1*Y1*Y2 + P2*Y3 + P7*Y3*Y7 - P8*Y1*Y8 + P9*Y6*Y7 
     &    - P10*Y1*Y9
C
*     FUNCTION Y2P
      Y2P = -P1*Y1*Y2 + P2*Y3 - P5*Y2*Y5 + P6*Y6
C
*     FUNCTION Y3P
      Y3P = P1*Y1*Y2 - P2*Y3 - P3*Y3 + P4*Y4*Y5 - P7*Y3*Y7 
     &    + P8*Y1*Y8 + P11*Y6*Y8 - P12*Y3*Y9
C
*     FUNCTION Y4P
      Y4P = P3*Y3 - P4*Y4*Y5 
C
*     FUNCTION Y5P
      Y5P = P3*Y3 - P4*Y4*Y5  - P5*Y2*Y5 + P6*Y6
C
*     FUNCTION Y6P
      Y6P = P5*Y2*Y5 - P6*Y6 - P9*Y6*Y7 + P10*Y1*Y9
     &    - P11*Y6*Y8 + P12*Y3*Y9 
C
*     FUNCTION Y7P
      Y7P = -P7*Y3*Y7 + P8*Y1*Y8 - P9*Y6*Y7 + P10*Y1*Y9 
C
*     FUNCTION Y8P
      Y8P = P7*Y3*Y7 - P8*Y1*Y8 - P11*Y6*Y8 + P12*Y3*Y9 
C
*     FUNCTION Y9P
      Y9P = P9*Y6*Y7 - P10*Y1*Y9 + P11*Y6*Y8 - P12*Y3*Y9 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION P1I
      P1I  =0.0
C
*     FUNCTION P2I
      P2I = 3.0
C
*     FUNCTION P3I
      P3I = 0.0
C
*     FUNCTION P4I
      P4I = 0.0
C
*     FUNCTION P5I
      P5I = 0.01
C
*     FUNCTION P6I
      P6I = 0.5
C
*     FUNCTION P7I
      P7I = 1.0
C
*     FUNCTION P8I
      P8I = 0.0
C
*     FUNCTION P9I
      P9I = 0.0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION Y4FIT
      Y4FIT = Y4
C
*     FUNCTION Y5FIT
      Y5FIT  =Y5
C
*     FUNCTION Y7FIT
      Y7FIT = Y7
C
*     FUNCTION Y8FIT
      Y8FIT = Y8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


