C
C------------------------------------------------------
C
C     Problem:    SHEEP
C
C     Date:       10.8.1999
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      a_gf = 0.83
      a_rbce = 0.13
      a_em = 3.7
      a_ek = 8.2
      a_el = 5.1
      a_le = 2.5
      a_ge = 0.39
C
C------------------------------------------------------
C    
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a_erbc, a_ku, a_lg, a_me, a_re, a_rg
      R, GIT, F, L, M, K, U, RBC, ECF, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION R_t
      F1 = a_rg*R
      F2 = a_gf*GIT
      F3 = a_re*R
      F4 = a_ge*GIT
      F5 = a_erbc*ECF
      F6 = a_rbce*RBC
      F7 = a_em*ECF
      F8 = a_me*M
      F9 = a_el*ECF
      F10 = a_lg*L
      F11 = a_ek*ECF
      F12 = a_ku*K
      F13 = a_le*L 
      if (t.le.100) then
        R_t = -F1 - F3  + 1
      else
        R_t = -F1 - F3
      endif    
C
*     FUNCTION GIT_t
      GIT_t = F1 - F2 - F4 + F10
C
*     FUNCTION F_t
      F_t = F2
C
*     FUNCTION L_t
      L_t = F9 - F10 - F13
C
*     FUNCTION M_t
      M_t = F7 - F8
C
*     FUNCTION K_t
      K_t = F11 - F12
C
*     FUNCTION U_t
      U_t = F12
C
*     FUNCTION RBC_t
      RBC_t = F5 - F6
C
*     FUNCTION ECF_t
      ECF_t = F3 + F4 - F5 + F6 - F7 + F8 - F9 - F11 + F13
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION R_0
      if (t.lt.1) then
        R_0 = 100
      else
        R_0 = R
      endif    
C
*     FUNCTION GIT_0
      if (t.lt.1) then
        GIT_0 = 0
      else
        GIT_0 = GIT
      endif    
C
*     FUNCTION F_0
      if (t.lt.1) then
        F_0 = 0
      else
        F_0 = F
      endif    
C
*     FUNCTION L_0
      if (t.lt.1) then
        L_0 = 0
      else
        L_0 = L
      endif    
C
*     FUNCTION M_0
      if (t.lt.1) then
        M_0 = 0
      else
        M_0 = M
      endif    
C
*     FUNCTION K_0
      if (t.lt.1) then
        K_0 = 0
      else
        K_0 = K
      endif    
C
*     FUNCTION U_0
      if (t.lt.1) then
        U_0 = 0
      else
        U_0 = U
      endif    
C
*     FUNCTION RBC_0
      if (t.lt.1) then
        RBC_0 = 0
      else
        RBC_0 = RBC
      endif    
C
*     FUNCTION ECF_0
      if (t.lt.1) then
        ECF_0 = 0
      else
        ECF_0 = ECF
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
c*     FUNCTION R_fit
c      R_fit = R
C
*     FUNCTION GIT_fit
      GIT_fit = GIT
C
*     FUNCTION F_fit
      F_fit = F
C
c*     FUNCTION L_fit
c      L_fit = L
C
*     FUNCTION M_fit
      M_fit = M
C
c*     FUNCTION K_fit
c      K_fit = K
C
*     FUNCTION U_fit
      U_fit = U
C
*     FUNCTION RBC_fit
      RBC_fit = RBC
C
*     FUNCTION ECF_fit
      ECF_fit = ECF
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
