C
C------------------------------------------------------
C
C     Problem:    SHEAR
C
C     Date:       20.06.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      DeltaT = 0.01
      V0 = 0.5
      d = 1.5
      r = 0.05
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Re, Pr, Ginf, Tm
      u, v, Temp, u_x, v_x, Temp_x, u_xx, v_xx, Temp_xx
      fu, fv, fTemp, fu_x, fv_x, fTemp_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION fluxu
      fluxu = 0
C
*     FUNCTION fluxv
      G = 0.5*((1+Ginf) - (1-Ginf)*tanh((Temp-Tm)/DeltaT))
      fluxv = G*u_x
C
*     FUNCTION fluxTemp
      fluxTemp = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = v
C
*     FUNCTION v_t
      v_t = fv_x + v_xx/Re
C
*     FUNCTION Temp_t
      Temp_t = Temp_xx/(Pr*Re) + v_x**2/Re
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0
C
*     FUNCTION v_0
      v_0 = 0
C
*     FUNCTION Temp_0
      Temp_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION v_l
      v_l = 0
C
*     FUNCTION Temp_l
      Temp_l = 0
C
*     FUNCTION v_r
      if (t.lt.r) then
        Vf = V0*t/r
      else
      if (t.lt.d-r) then
        Vf = V0
      else
      if (t.lt.d) then
        Vf = V0*(d-t)/r
      else
        Vf = 0 
      endif
      endif
      endif
      v_r = Vf
C
*     FUNCTION Temp_r
      Temp_r = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT_u
      FIT_u = u
C
*     FUNCTION FIT_v
      FIT_v = v
C
*     FUNCTION FIT_Temp
      FIT_Temp = Temp
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
