C
C------------------------------------------------------
C
C     Problem:    SHAKER
C
C     Date:       18.11.2003
C
C------------------------------------------------------
C               
*     REAL CONSTANT
      Ec = 12
      r = 0.208
      B = 1               
      bb = 0.9
      m = 1
C
C------------------------------------------------------
C               
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ra, La, Jm, K1, K2, Qm, Om, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Qm_t
      ta = La/Ra
      AQ = K1*Ec/Ra
      SO = K1*K2/Ra
      SQ = 1/(B + bb*r**2)
      tmT = (Jm + m*r**2)/(B + bb*r**2)
      OI = SQ*Qm
      QI = AQ - SO*Om

      Qm_t = (QI - Qm)/ta 
C
*     FUNCTION Om_t
      Om_t = (OI - Om)/tmT
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Qm_0
      Qm_0 = 0
C
*     FUNCTION Om_0
      Om_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Qm_fit
      Qm_fit = Qm
C
*     FUNCTION Om_fit
      Om_fit = Om
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
