C
C------------------------------------------------------
C
C     Problem:    SETTLER
C
C     Date:       03.04.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      diameter = 33
      A = pi*(diameter/2)**2
      Qu = 1
      Q0 = 10
      rh = 0.277
      rp = 3.86
      V0min = 7.02
      xmin = 0.0684
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      V0, Ds, Dsp
      x, x_z, x_zz, f, f_z, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux1
      Vs1 = V0*(EXP(-rh*(x - xmin)) - EXP(-rp*(x-xmin)))
      IF (Vs1.GT.V0min) THEN
        Vs = V0min
      ELSE
        Vs = Vs1
      ENDIF
      IF (Vs.LT.0) THEN
        Vs = 0
      ENDIF
      flux1 = -Qu/A*x - Vs*x + Ds*x_z
C
*     FUNCTION flux2
      Vs1 = V0*(EXP(-rh*(x - xmin)) - EXP(-rp*(x-xmin)))
      IF (Vs1.GT.V0min) THEN
        Vs = V0min
      ELSE
        Vs = Vs1
      ENDIF
      IF (Vs.LT.0) THEN
        Vs = 0
      ENDIF
      flux2 = -Q0/A*x + Vs*x + Dsp*x_z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION x1_t
      x1_t = f_z
C
*     FUNCTION x2_t
      x2_t = f_z
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION x1_0
      x1_0 = 0.1
C
*     FUNCTION x2_0
      x2_0 = 0.1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION x1_left
      x1_left = 0
C
*     FUNCTION x2_left
      x2_left = x
C
*     FUNCTION x2_right
      x2_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION x2_z_right
      x2_z_right = x_z
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



