C
C------------------------------------------------------
C
C     Problem:    SEMIPAR
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      nA=1
      nP=1
      nB1=1.0
      nB2=1.5
      Vin=0.5
      Vtank=10
      Bfeed=1
      VAin=1
      VBin=0
      VPin=0 
      VQin=0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, VA, VB, VP, VQ, V, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VA_t
      IF (VA.LT.0) THEN
        A=0
      ELSE
        A=VA/V
      ENDIF
      IF (VB.LT.0) THEN
        B=0
      ELSE
        B=VB/V
      ENDIF
      P=VP/V
      Q=VQ/V
      IF ((A.GT.0).AND.(B.GT.0)) THEN
        r1=k1*(A**nA)*(B**nB1)
      ELSE
        r1=0
      ENDIF
      IF ((B.GT.0).AND.(P.GT.0)) THEN
        r2=k2*(P**nP)*(B**nB2)
      ELSE
        r2=0
      ENDIF
      VA_t=-r1*V
C
*     FUNCTION VB_t
c      IF ((V.GE.Vtank).OR.((P.LE.0).AND.(T.GT.10))) THEN
c        F=0
c      ELSE
        F=0.05
c      ENDIF
      VB_t=F*Bfeed-(r1+r2)*V
C
*     FUNCTION VP_t
      VP_t=(r1-r2)*V
C
*     FUNCTION VQ_t
      VQ_t=r2*V
C
*     FUNCTION V_t
      V_t=F
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION VA_0
      VA_0=VAin
C
*     FUNCTION VB_0
      VB_0=VBin
C
*     FUNCTION VP_0
      VP_0=VPin
C
*     FUNCTION VQ_0
      VQ_0=VQin
C
*     FUNCTION V_0
      V_0=Vin
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION SEL_fit
      SEL=VP/(VQ+0.001)
      SEL_fit =SEL
C
*     FUNCTION VA_fit
      VA_fit = VA
C
*     FUNCTION VB_fit
      VB_fit = VB
C
*     FUNCTION VP_fit
      VP_fit = VP
C
*     FUNCTION VQ_fit
      VQ_fit = VQ
C
*     FUNCTION V_fit
      V_fit = V
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
