C
C------------------------------------------------------
C
C     Problem:    SEMISEQ
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Da, Eta, Thetamix, V, I, y, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Vp
      Vp=1
C
*     FUNCTION Ip
      Theta=T+0.01
      Ip=(1 - I)/Theta - I/Thetamix
C
*     FUNCTION yp
      If (Theta.lt.1.0) THEN
        A=Theta
      ELSE
        A=1
      ENDIF
      yp= (1 - y)/A - Da*(y*(y + Eta - 1) - I*Eta)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION V_0
      V_0 = 0
C
*     FUNCTION I_0
      I_0 = 1 
C
*     FUNCTION y_0
      y_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION V_fit
      V_fit = V
C
*     FUNCTION I_fit
      I_fit = I
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
