C
C------------------------------------------------------
C
C     Problem:    SEMIPAR
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      nA1=1
      nA2=1
      nB1=1.5
      nB2=2.5
      Vin=0.5
      Vtank=1
      Bfeed=1
      VAin=1
      VBin=0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, VA, VB, VP, VQ, V, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VA_t
      IF (V.GE.Vtank) THEN
        F=0
      ELSE
        F=0.05
      ENDIF
      IF (VA.LT.0) THEN
        A=0
      ELSE
        A=VA/V
      ENDIF
      IF (VB.LT.0) THEN
        B=0
      ELSE
        B=VB/V
      ENDIF
      IF ((A.GT.0).AND.(B.GT.0)) THEN
        r1=k1*(A**nA1)*(B**nB1)
        r2=k2*(A**nA2)*(B**nB2)
      ELSE
        r1=0
        r2=0
      ENDIF
      VA_t=-(r1+r2)*V
C
*     FUNCTION VB_t
      VB_t=F*Bfeed-(r1+r2)*V
C
*     FUNCTION VP_t
      VP_t=r1*V
C
*     FUNCTION VQ_t
      VQ_t=r2*V
C
*     FUNCTION V_t
      V_t=F
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION VA_0
      VA_0=VAin
C
*     FUNCTION VB_0
      VB_0=VBin
C
*     FUNCTION VP_0
      VP_0=0
C
*     FUNCTION VQ_0
      VQ_0=0
C
*     FUNCTION V_0
      V_0=Vin
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION SEL_fit
      SEL=VP/(VQ+0.001)
      SEL_fit =SEL
C
*     FUNCTION VA_fit
      VA_fit = VA
C
*     FUNCTION VB_fit
      VB_fit = VB
C
*     FUNCTION VP_fit
      VP_fit = VP
C
*     FUNCTION VQ_fit
      VQ_fit = VQ
C
*     FUNCTION V_fit
      V_fit = V
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
