C
C------------------------------------------------------
C
C     Problem:    SEIR
C
C     Date:       12.05.2004
C
C------------------------------------------------------
C           
*     REAL CONSTANT
      S0 = 1
      E0 = 0.013
      IU0 = 0.54
      ID0 = 2.4
      R0 = 0.1
      D0 = 3 
C
C------------------------------------------------------
C           
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, bU, bD, b1, S, E, IU, ID, R, D, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S_t
      S_t = -R*S*IU
C
*     FUNCTION E_t
      E_t = R*S*IU - a*E
C
*     FUNCTION IU_t
      IU_t = a*E - (b + bU + b1)*IU
C
*     FUNCTION ID_t
      ID_t = bU*IU - (bD + b1)*ID
C
*     FUNCTION R_t
      R_t = b*IU + bD*ID
C
*     FUNCTION D_t
      D_t = b1*(IU + ID)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S_0
      S_0 = S0
C
*     FUNCTION E_0
      E_0 = E0
C
*     FUNCTION IU_0
      IU_0 = IU0
C
*     FUNCTION ID_0
      ID_0 = ID0
C
*     FUNCTION R_0
      R_0 = R0
C
*     FUNCTION D_0
      D_0 = D0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ID_fit
      ID_fit = ID
C
*     FUNCTION R_fit
      R_fit = R
C
*     FUNCTION D_fit
      D_fit = D
C
*     FUNCTION S_plot
      S_plot = S
C
*     FUNCTION E_plot
      E_plot = E
C
*     FUNCTION IU_plot
      IU_plot = IU
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = 1/b - 1/bU - 1/bD 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
