C
C------------------------------------------------------
C
C     Problem:    SCP
C
C     Date:       22.09.2005
C
C------------------------------------------------------
C               
*     REAL CONSTANT
      eps = 0.01
C
C------------------------------------------------------
C                                                 
*     MACRO u
      if (t.lt.t1) then
        u = a1
      endif
      if ((t.ge.t1).and.(t.lt.t2)) then
        u = a2
      endif
      if ((t.ge.t2).and.(t.lt.t3)) then
        u = a3
      endif
      if ((t.ge.t3).and.(t.lt.t4)) then
        u = a4
      endif
      if ((t.ge.t4).and.(t.lt.t5)) then
        u = a5
      endif
      if (t.ge.t5) then
        u = a6
      endif
C
C------------------------------------------------------
C                                                 
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a1, a2, a3, a4, a5, a6, t1, t2, t3, t4, t5
      x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x2
C
*     FUNCTION x2_t
      x2_t = -x3*u + 16*x4 - 8
C
*     FUNCTION x3_t
      x3_t = u
C
*     FUNCTION x4_t
      x4_t = 1
C
*     FUNCTION x5_t
      x5_t = x1**2 + x2**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0  
      if (t.eq.0) then
        x1_0 = 0
      else
        x1_0 = x1
      endif     
C
*     FUNCTION x2_0
      if (t.eq.0) then
        x2_0 = -1
      else
        x2_0 = x2
      endif     
C
*     FUNCTION x3_0
      if (t.eq.0) then
        x3_0 = -sqrt(5)
      else
        x3_0 = x3
      endif     
C
*     FUNCTION x4_0
      if (t.eq.0) then
        x4_0 = 0
      else
        x4_0 = x4
      endif     
C
*     FUNCTION x5_0
      if (t.eq.0) then
        x5_0 = 0
      else
        x5_0 = x5
      endif     
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION ctrl
      ctrl = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = t2 - t1 - eps
C
*     FUNCTION g2
      g2 = t3 - t2 - eps
C
*     FUNCTION g3
      g3 = t4 - t3 - eps
C
*     FUNCTION g4
      g4 = t5 - t4 - eps
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
