C
C------------------------------------------------------
C
C     Problem:    SCARA
C
C     Date:       15.10.2003
C
C------------------------------------------------------
C     
*     CONINT u1
      0.0   50.0
      0.2   50.0
      0.4   50.0
      0.6  -50.0
      0.8  -50.0
      1.0   50.0
      1.2  200.0
      1.4  200.0
      1.6  100.0
      1.8  100.0
      2.0  100.0
C     
*     CONINT u2
      0.0  100.0
      0.2 -100.0
      0.4  -50.0
      0.6  100.0
      0.8   50.0
      1.0   50.0
      1.2   50.0
      1.4   50.0
      1.6  -50.0
      1.8  -50.0
      2.0  -50.0
C
C------------------------------------------------------
C     
*     REAL CONSTANT
      m1 = 40
      m2 = 40
C
C------------------------------------------------------
C        
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      r10, J10, r20, J20
      x1, y1, x2, y2, vx1, vy1, vx2, vy2
      lambda1, lambda2
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = vx1   
C
*     FUNCTION y1_t
      y1_t = vy1   
C
*     FUNCTION x2_t
      x2_t = vx2   
C
*     FUNCTION y2_t
      y2_t = vy2   
C
*     FUNCTION vx1_t
      r1 = r10*0.4  
      J1 = J10*2.1
      r2 = r20*0.4
      J2 = J20*2.1
      u1s = u1(t)/r1**2
      u2s = u2(t)/r2**2
      J1s = J1/r1**2
      J2s = J2/r2**2
      f1 = (-u1s + u2s)*y1
      f2 = (u1s - u2s)*x1
      f3 = u2s*(-y2 + 2*y1)    
      f4 = u2s*(x2 - 2*x1)
      G11 = 2*x1 
      G12 = 2*y1
      G21 = -4*x2 + 8*x1
      G22 = -4*y2 + 8*y1
      G23 = 2*x2 - 4*x1
      G24 = 2*y2 - 4*y1
      gamma1 = -2*vx1**2 - 2*vy1**2
      gamma2 = -2*(vx2 - vx1)**2 - 2*(vy2 - vy1)**2
      Mc1 = m1 + J1s + 4*J2s
      Mc2 = m2 + J2s
      Mc3 = -4*J2s  
      det = Mc3**2 - Mc1*Mc2
      Mc1i = -Mc2/det
      Mc2i = -Mc1/det
      Mc3i = Mc3/det  
      rw1 = f1 - G11*lambda1 - G21*lambda2
      rw2 = f2 - G12*lambda1 - G22*lambda2
      rw3 = f3 - G23*lambda2
      rw4 = f4 - G24*lambda2
      rhs1 = Mc1i*rw1 + Mc3i*rw3
      rhs2 = Mc1i*rw2 + Mc3i*rw4 
      rhs3 = Mc3i*rw1 + Mc2i*rw3
      rhs4 = Mc3i*rw2 + Mc2i*rw4
      vx1_t = rhs1 
C
*     FUNCTION vx2_t
      vx2_t = rhs2
C
*     FUNCTION vx3_t
      vx3_t = rhs3 
C
*     FUNCTION vx4_t
      vx4_t = rhs4 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg1
      r1 = r10*0.4  
      J1 = J10*2.1
      r2 = r20*0.4
      J2 = J20*2.1
      u1s = u1(t)/r1**2
      u2s = u2(t)/r2**2
      J1s = J1/r1**2
      J2s = J2/r2**2
      f1 = (-u1s + u2s)*y1
      f2 = (u1s - u2s)*x1
      f3 = u2s*(-y2 + 2*y1)    
      f4 = u2s*(x2 - 2*x1)
      G11 = 2*x1 
      G12 = 2*y1
      G21 = -4*x2 + 8*x1
      G22 = -4*y2 + 8*y1
      G23 = 2*x2 - 4*x1
      G24 = 2*y2 - 4*y1
      gamma1 = -2*vx1**2 - 2*vy1**2
      gamma2 = -2*(vx2 - vx1)**2 - 2*(vy2 - vy1)**2
      Mc1 = m1 + J1s + 4*J2s
      Mc2 = m2 + J2s
      Mc3 = -4*J2s  
      det = Mc3**2 - Mc1*Mc2
      Mc1i = -Mc2/det
      Mc2i = -Mc1/det
      Mc3i = Mc3/det  
      rw1 = f1 - G11*lambda1 - G21*lambda2
      rw2 = f2 - G12*lambda1 - G22*lambda2
      rw3 = f3 - G23*lambda2
      rw4 = f4 - G24*lambda2
      rhs1 = Mc1i*rw1 + Mc3i*rw3
      rhs2 = Mc1i*rw2 + Mc3i*rw4 
      rhs3 = Mc3i*rw1 + Mc2i*rw3
      rhs4 = Mc3i*rw2 + Mc2i*rw4
      alg1 = gamma1 - G11*rhs1 - G12*rhs2 
C
*     FUNCTION alg2
      alg2 = gamma2 - G21*rhs1 - G22*rhs2 - G23*rhs3 - G24*rhs4 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0         
      if (t.lt.0.001) then
        x1_0 = 0
      else
        x1_0 = x1
      endif    
C
*     FUNCTION y1_0
      if (t.lt.0.001) then
        y1_0 = -0.8
      else
        y1_0 = y1
      endif    
C
*     FUNCTION x2_0
      if (t.lt.0.001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif    
C
*     FUNCTION y2_0
      if (t.lt.0.001) then
        y2_0 = -1.4
      else
        y2_0 = y2
      endif    
C
*     FUNCTION vx1_0
      if (t.lt.0.001) then
        vx1_0 = 0
      else
        vx1_0 = vx1
      endif    
C
*     FUNCTION vy1_0
      if (t.lt.0.001) then
        vy1_0 = 0
      else
        vy1_0 = vy1
      endif    
C
*     FUNCTION vx2_0
      if (t.lt.0.001) then
        vx2_0 = 0
      else
        vx2_0 = vx2
      endif    
C
*     FUNCTION vy2_0
      if (t.lt.0.001) then
        vy2_0 = 0
      else
        vy2_0 = vy2
      endif    
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION lambda1_0
      if (t.lt.0.001) then
        lambda1_0 = 0
      else
        lambda1_0 = lambda1
      endif    
C
*     FUNCTION lambda2_0
      if (t.lt.0.001) then
        lambda2_0 = 0
      else
        lambda2_0 = lambda2
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = 2*x1
C
*     FUNCTION y1_fit
      y1_fit = 2*y1
C
*     FUNCTION x2_fit
      x2_fit = 2*(x2 - x1)
C
*     FUNCTION y2_fit
      y2_fit = 2*(y2 - y1)
C
*     FUNCTION u1_ctrl
      u1_ctrl = u1(t)
C
*     FUNCTION u2_ctrl
      u2_ctrl = u2(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
