C
C------------------------------------------------------
C
C     Problem:    SBR_COOL
C
C     Date:       13.11.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      cpr = 4.187
      Tf = 310
      Ta = 273
      dH1 = -40000
      dH2 = -50000
      Uloss = 0.057
      Ar0 = 5
      Vr0 = 1
      rhor = 100
      E1 = 30000
      E2 = 40000
      R = 8.314
      rhow = 1000
      cpw = 4.187
      FMw = 4
      tauc = 100
      Fa = 0.5
      Tc = 350
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      MWa, alphaw, Vw, k01, k02
      ca, cb, Vr, naint, Tr, Tw, Twin, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ca_t
      ca_t = Fa/Vr - k01*1E-9*exp(-E1/(R*Tr)*ca)
C
*     FUNCTION cb_t
      cb_t = -(k01*1E-9*exp(-E1/(R*Tr))*ca - k02*1E-9*exp(-E2/(R*Tr)*cb))
C
*     FUNCTION Vr_t
      Vr_t = Fa*MWa/rhor
C
*     FUNCTION naint_t
      naint_t = Fa
C
*     FUNCTION Tr_t
      Tr_t = Vr*Fa*MWa*cpr*(Tf - Tr) - Vr*k01*1E-9*exp(-E1/(R*Tr))*ca*dH1
     /       - Vr*k02*1E-9*exp(-E2/(R*Tr))*cb*dH2
     /       + alphaw*Ar0*Vr/Vr0*(Tw - Tr)/(rhor*Vr*cpr)
C
*     FUNCTION Tw_t
      Tw_t = (FMw*cpw*(Twin - Tw) - alphaw*Ar0*Vr/Vr0*(Tw - Tr))/(rhow*Vw*cpw)
C
*     FUNCTION Twin_t
      Twin_t = (Tc - Twin)/tauc
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION ca_0
      ca_0 = 0
C
*     FUNCTION cb_0
      cb_0 = 0
C
*     FUNCTION Vr_0
      Vr_0 = Vr0
C
*     FUNCTION naint_0
      naint_0 = 0
C
*     FUNCTION Tr_0
      Tr_0 = 300
C
*     FUNCTION Tw_0
      Tw_0 = 300
C
*     FUNCTION Twin_0
      Twin_0 = 300
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ca_fit
      ca_fit = ca
C
*     FUNCTION cb_fit
      cb_fit = cb
C
*     FUNCTION Vr_fit
      Vr_fit = Vr
C
*     FUNCTION naint_fit
      naint_fit = naint
C
*     FUNCTION Tr_fit
      Tr_fit = Tr
C
*     FUNCTION Tw_fit
      Tw_fit = Tw
C
*     FUNCTION Twin_fit
      Twin_fit = Twin
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g
c      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
