C
C------------------------------------------------------
C
C     Problem:    SAT_EXP
C
C     Date:       4.12.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      b00=5000
      arg00=1.775221E+03
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1a, k1d, k2a, k2d, k1, k2, br, ar, arg, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION brp
      brp=k2a*(b00-br)*(arg00-arg-ar-br)-k2d*br
C
*     FUNCTION arp
      arp=k1a*(arg00-arg-ar-br)*(arg00-arg-ar)-k1d*ar+k2*arg
     /   -k1*ar
C
*     FUNCTION argp
      argp=k1*ar-k2*arg
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION br0
      br0=0
C
*     FUNCTION ar0
      ar0=0
C
*     FUNCTION arg0
      arg0=arg00
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1=br
C
*     FUNCTION FIT2
      FIT2=ar
C
*     FUNCTION FIT3
      FIT3=arg
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
