C
C------------------------------------------------------
C
C     Problem:    SALINE
C
C     Date:       18.11.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, b, q, C0, c, z, c_x, z_x, c_xx, z_xx, 
     /     c1, c2, fc, fz, fc_x, fz_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_c
      P = exp(-b*(z/(1+c))**2)
      flux_c = P*c_x
C
*     FUNCTION flux_z
      flux_z = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_t
      c_t = fc_x - q*c
C
*     FUNCTION z_t
      z_t = q*c
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_0
      c_0 = 0
C
*     FUNCTION z_0
      z_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION c1_t
      P = exp(-b*(z/(1+c))**2)
      c1_t = D*P*c_x
C
*     FUNCTION c2_t
c      P = exp(-b*(z/(1+c))**2)
      c2_t = -D*P*c_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION c1_0
      c1_0 = C0
C
*     FUNCTION c2_0
      c2_0 = 0 
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION c_l
      c_l = c1
C
*     FUNCTION c_r
      c_r = c2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_1
      fit_1 = c1*100000
C
*     FUNCTION fit_2
      fit_2 = c2*100000
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

