C
C------------------------------------------------------
C
C     Problem:    RUN
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      M0 = 4400  
      MOL = 74   
      F0 = 100   
      FC = 5000  
      T0 = 80
      LAMBDA = 670   
      E = 21000  
      Z = 9.00000E+09
      R = 1.987  
      HR = -1660 
      PBURST = 6
      KV = 10000
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CP, M, MC, TR, X, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION MP
      C = MC/M 
      K = Z*EXP(-E/(R*(TR+273)))
      N = M0/MOL  
      F = F0  
      MWEI = (M0 + X)/N   
      P = (EXP(-3430/(TR+273)+11.7)+1.45E-3*MWEI)*C   
      IF (P.LT.1) THEN
        P = 1 
        V = 0  
      ENDIF
      IF (P.GE.PBURST) THEN
        F = 0
        IF (P.GE.1.9) THEN
          V = 0.85*KV*P/SQRT(TR+273)
        ENDIF
        IF ((P.LT.1.9).AND.(P.GT.1)) THEN
          V = KV*P/SQRT(TR+273)*SQRT(1+1/P/P)
        ENDIF
      ENDIF
      MP = F-V
C
*     FUNCTION MCP
      RR = K*MC   
      MCP = F-V-RR
C
*     FUNCTION TRP
      TRP = (F*(T0-TR)-V*LAMBDA/CP-RR*HR/CP-FC*(TR-T0))/M 
C
*     FUNCTION XP  
      XP = RR
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION M_0
      M_0 = M0
C
*     FUNCTION MC_0
      MC_0 = 0
C
*     FUNCTION TR_0
      TR_0 = 0
C
*     FUNCTION X_0
      X_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION P_fit
      C = MC/M 
      K = Z*EXP(-E/(R*(TR+273)))
      N = M0/MOL  
      F = F0  
      MWEI = (M0 + X)/N   
      P = (EXP(-3430/(TR+273)+11.7)+1.45E-3*MWEI)*C   
      IF (P.LT.1) THEN
        P = 1 
        V = 0  
      ENDIF
      IF (P.GE.PBURST) THEN
        F = 0
        IF (P.GE.1.9) THEN
          V = 0.85*KV*P/SQRT(TR+273)
        ENDIF
        IF ((P.LT.1.9).AND.(P.GT.1)) THEN
          V = KV*P/SQRT(TR+273)*SQRT(1+1/P/P)
        ENDIF
      ENDIF
      P_fit = P
C
*     FUNCTION V_fit
      V_fit = V
C
*     FUNCTION M_fit
      M_fit = M
C
*     FUNCTION MC_fit
      MC_fit = MC
C
*     FUNCTION TR_fit
      TR_fit = TR
C
*     FUNCTION X_fit
      X_fit = X
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
