C
C------------------------------------------------------
C
C     Problem:    RT_PULSE
C
C     Date:       30.05.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a0, a1, a2, a3, a4, a5, a6, x1, x2, x3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x2 - 1
C
*     FUNCTION x2_t
      u = a0 + a1*t + a2*t**2 + a3*t**3 + a4*t**4 + a5*t**5 + a6*t**6
      if ((t.ge.0.5).and.(t.le.0.6)) then
        p = 1
      else
        p = 0
      endif
      x2_t = -x1 - x2 + 100*p*u
C
*     FUNCTION x3_t
      x3_t = 5*x1**2 + 2.5*x2**2 + 0.5*u**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.0001) then
        x1_0 = 0
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.0001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.0001) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION u_ctrl
      u = a0 + a1*t + a2*t**2 + a3*t**3 + a4*t**4 + a5*t**5 + a6*t**6
      u_ctrl = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C








