C
C------------------------------------------------------
C
C     Problem:    ROB_CTRL
C
C     Date:       05.06.2002
C
C------------------------------------------------------
C
*     MACRO u1
      if (t.lt.0.5) then
        u1 = 1
      else
        u1 = -1
      endif
C
*     MACRO u2
      if (t.lt.t21) then
        u2 = 1
      else
      if (t.lt.t22) then
        u2 = -1
      else
      if (t.lt.t23) then
        u2 = 1
      else
      if (t.lt.t24) then
        u2 = -1
      else
        u2 = 1
      endif
      endif
      endif
      endif
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      tf, t21, t22, t23, t24, x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      s3 = sin(x3)
      c3 = cos(x3)
      D = 31/36 + 9/4*s3**2
      x1_t = tf*(s3*(9/4*c3*x1**2 + 2*x2**2) + 4/3*(u1-u2) 
     /                                      - 3/2*c3*u2)/D
C
*     FUNCTION x2_t
      x2_t = -tf*(s3*(7/2*x1**2 + 9/4*c3*x2**2) - 7/3*u2 
     /                                 + 3/2*c3*(u1-u2))/D
C
*     FUNCTION x3_t
      x3_t = tf*(x2 - x1)
C
*     FUNCTION x4_t
      x4_t = tf*x1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.000001) then
        x1_0 = 0
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.000001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.000001) then
        x3_0 = 0.5
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.000001) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_state
      x1_state = x1
C
*     FUNCTION x2_state
      x2_state = x2
C
*     FUNCTION x3_state
      x3_state = x3
C
*     FUNCTION x4_state
      x4_state = x4
C
*     FUNCTION u1_ctrl
      u1_ctrl = u1
C
*     FUNCTION u2_ctrl
      u2_ctrl = u2
C
*     FUNCTION terminal
      terminal = sqrt(tf)*0.01
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = x1
C
*     FUNCTION g2
      g2 = x2 
C
*     FUNCTION g3
      g3 = t22 - t21 - 0.0001
C
*     FUNCTION g4
      g4 = t23 - t22 - 0.0001
C
*     FUNCTION g5
      g5 = t24 - t23 - 0.0001
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


