C
C------------------------------------------------------
C
C     Problem:    ROB_ARM
C
C     Date:       19.11.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L1 = 1
      L2 = 1
      U1 = 1
      U2 = -0.4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      J11, J12, J22, ALPHA, THETA, OMEGA1, OMEGA2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ALPHAP
      ALPHAP = OMEGA2 - OMEGA1
C
*     FUNCTION THETAD
      THETAD = OMEGA1
C
*     FUNCTION OMEG1D
      DET = J11*J22 - J12**2*(COS(ALPHA))**2 
      R1 = J12*OMEGA2**2*SIN(ALPHA) + U1 - U2
      R2 = -J12*OMEGA1**2*SIN(ALPHA) + U2
      OMEG1D = (J22*R1 - J12*COS(ALPHA)*R2)/DET
C
*     FUNCTION OMEG2D
      OMEG2D = (J11*R2 - J12*COS(ALPHA)*R1)/DET
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION ALPHA0
      ALPHA0 = -0.1
C
*     FUNCTION THETA0
      THETA0 = 0.05
C
*     FUNCTION OMEG01
      OMEG01 = -0.2
C
*     FUNCTION OMEG02
      OMEG02 = 0.2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X
      X = L1*COS(THETA) + L2*COS(THETA+ALPHA) 
C
*     FUNCTION Y
      Y = L1*SIN(THETA) + L2*SIN(THETA+ALPHA) 
C
*     FUNCTION AFIT
      AFIT = ALPHA
C
*     FUNCTION TFIT
      TFIT = THETA
C
*     FUNCTION OFIT1
      OFIT1 = OMEGA1
C
*     FUNCTION OFIT2
      OFIT2 = OMEGA2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

