C
C------------------------------------------------------
C
C     Problem:    ROBOT_2
C
C     Date:       17.01.1997
C
C------------------------------------------------------
C      
*     PARAMETER
      n = 6      
      n1 = 5   
      n2 = 4    
C
C------------------------------------------------------
C      
*     SET OF INDICES
      ind = 1..n 
      ind1 = 1..n1
      ind2 = 1..n2
C
C------------------------------------------------------
C      
*     INDEX
      i
C
C------------------------------------------------------
C                   
*     MACRO u1        
      u1 = 0
      i = 1   
 1100 continue     
      if (t.lt.tb(i)) then
        u1 = v1(i)
        goto 1200
      endif  
      i = i+1  
      if (i.lt.n) then
        goto 1100
      endif
      u1 = v1(i)  
 1200 continue
C
*     MACRO u2
      u2 = 0
      i = 1   
 2100 continue     
      if (t.lt.tb(i)) then
        u2 = v2(i)
        goto 2200
      endif  
      i = i+1  
      if (i.lt.n) then
        goto 2100
      endif
      u2 = v2(i)  
 2200 continue
C
C------------------------------------------------------
C
*     REAL CONSTANT
      ta1 = 1.6
      ta2 = 0.43
      ta3 = 0.01
      l1 = 0.4
      l2 = 0.25
      r2 = 0.125
      m2 = 15.0
      m3 = 6.0
      t_f = 0.97581
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      v1(j), j in ind
      v2(j), j in ind
      tb(j), j in ind1
      x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p
      x1_p = x2
C
*     FUNCTION x2_p
      ta4 = ta2 + l2**2*m3
      ta5 = ta1 + l1**2*(m2 + m3)
      ta6 = l1*(r2*m2 + l2*m3)
      ta7 = ta3 + ta4
      det = ta7*ta5 - ta6**2*cos(x3)**2
      x2_p = (ta7*(u1 - u2 + ta6*(x2 + x4)**2*sin(x3)) - 
     /        ta6*(u2 - ta6*x2**2*sin(x3))*cos(x3))/det
C
*     FUNCTION x3_p
      x3_p = x4
C
*     FUNCTION x4_p
      x4_p = ((ta5 + ta6*cos(x3))*(u2 - ta6*x2**2*sin(x3))
     /       - (ta7 + ta6*cos(x3))*
     /         (u1 - u2 + ta6*(x2 + x4)**2*sin(x3)))/det 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0    
      if (t.lt.1E-9) then
        x1_0 = 0.0
      else
        x1_0 = x1
      endif    
C
*     FUNCTION x2_0
      if (t.lt.1E-9) then
        x2_0 = 0.0
      else
        x2_0 = x2
      endif    
C
*     FUNCTION x3_0
      if (t.lt.1E-9) then
        x3_0 = 0.0
      else
        x3_0 = x3
      endif    
C
*     FUNCTION x4_0
      if (t.lt.1E-9) then
        x4_0 = 0.0
      else
        x4_0 = x4
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION u1_fit
      u1_fit = u1
C
*     FUNCTION u2_fit
      u2_fit = u2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(j), j in ind2  
      g(j) = tb(j+1) - tb(j) - 0.001
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


