C
C------------------------------------------------------
C
C     Problem:    ROBOT
C
C     Date:       14.10.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      rho1=-105.D0
      RJ1=1.3d-3
      J133=1.16D0
      g=9.81D0
      rho2=210.D0
      RJ2=1.3d-3
      m2=56.5d0
      h23=0.50d0
      d21=0.172d0
      d23=0.205d0
      rho3=60.d0
      RJ3=1.3d-3
      mh=60.3d0
      hh3=0.98d0
      dh1=0.028d0
      dh3=0.202d0
      ML=10
      v1=-126
      v2=252
      v3=72
      u1=0.21
      u2=0.28
      u3=0.37
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      I211, I222, I233, I231, IH11, IH22, IH33, IH31
      Q1, Q2, Q3, QD1, QD2, QD3
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION QDD1
      QDD1=QD1
C
*     FUNCTION QDD2
      QDD2=QD2
C
*     FUNCTION QDD3
      QDD3=QD3
C
*     FUNCTION QP1
      fgen1=v1*u1
      fgen2=v2*u2
      fgen3=v3*u3
      I213=I231
      IH13=IH31
      J11=SIN(Q2+Q3)**2*IH22+SIN(Q2+Q3)**2*DH3**2*MH+
     + SIN(Q2+Q3)**2*HH3**2*ML+2.D0*SIN(Q2+Q3)*SIN(Q2)*H23*
     + DH3*MH+2.D0*SIN(Q2+Q3)*SIN(Q2)*H23*HH3*ML+SIN(Q2)**2*
     + H23**2*MH+SIN(Q2)**2*H23**2*ML+SIN(Q2)**2*I222+SIN(
     + Q2)**2*D23**2*M2+COS(Q2+Q3)**2*IH33+COS(Q2)**2*I233+
     + MH*DH1**2+RJ1*RHO1**2+J133+D21**2*M2
      J12=-(COS(Q2+Q3)*DH3*MH*DH1-COS(Q2+Q3)*IH31+COS(
     + Q2)*H23*MH*DH1-COS(Q2)*I231+COS(Q2)*D21*D23*M2)
      J13=-COS(Q2+Q3)*(DH3*MH*DH1-IH31)
      J21=-(COS(Q2+Q3)*DH3*MH*DH1-COS(Q2+Q3)*IH31+COS(
     + Q2)*H23*MH*DH1-COS(Q2)*I231+COS(Q2)*D21*D23*M2)
      J22=SIN(Q3)**2*DH3**2*MH+SIN(Q3)**2*HH3**2*ML+
     + COS(Q3)**2*DH3**2*MH+COS(Q3)**2*HH3**2*ML+2.D0*COS(Q3)
     + *H23*DH3*MH+2.D0*COS(Q3)*H23*HH3*ML+H23**2*MH+H23**2*
     + ML+RJ2*RHO2**2+I211+IH11+D23**2*M2
      J23=SIN(Q3)**2*DH3**2*MH+SIN(Q3)**2*HH3**2*ML+
     + COS(Q3)**2*DH3**2*MH+COS(Q3)**2*HH3**2*ML+COS(Q3)*
     + H23*DH3*MH+COS(Q3)*H23*HH3*ML+RJ3*RHO3+IH11
      J31=-COS(Q2+Q3)*(DH3*MH*DH1-IH31)
      J32=SIN(Q3)**2*DH3**2*MH+SIN(Q3)**2*HH3**2*ML+
     + COS(Q3)**2*DH3**2*MH+COS(Q3)**2*HH3**2*ML+COS(Q3)*
     + H23*DH3*MH+COS(Q3)*H23*HH3*ML+RJ3*RHO3+IH11
      J33=DH3**2*MH+HH3**2*ML+RJ3*RHO3**2+IH11
      GAM111=0
      GAM112=-(SIN(Q2+Q3)*COS(Q2+Q3)*IH22+SIN(Q2+Q3)
     + *COS(Q2+Q3)*DH3**2*MH+SIN(Q2+Q3)*COS(Q2+Q3)*HH3**2*
     + ML-SIN(Q2+Q3)*COS(Q2+Q3)*IH33+SIN(Q2+Q3)*COS(Q2)*H23
     + *DH3*MH+SIN(Q2+Q3)*COS(Q2)*H23*HH3*ML+SIN(Q2)*COS(Q2
     + +Q3)*H23*DH3*MH+SIN(Q2)*COS(Q2+Q3)*H23*HH3*ML+SIN(Q2
     + )*COS(Q2)*H23**2*MH+SIN(Q2)*COS(Q2)*H23**2*ML-SIN(Q2
     + )*COS(Q2)*I233+SIN(Q2)*COS(Q2)*I222+SIN(Q2)*COS(Q2)*
     + D23**2*M2)
      GAM113=-COS(Q2+Q3)*(SIN(Q2+Q3)*IH22+SIN(Q2+Q3)
     + *DH3**2*MH+SIN(Q2+Q3)*HH3**2*ML-SIN(Q2+Q3)*IH33+SIN(
     + Q2)*H23*DH3*MH+SIN(Q2)*H23*HH3*ML)
      GAM121=-(SIN(Q2+Q3)*COS(Q2+Q3)*IH22+SIN(Q2+Q3)
     + *COS(Q2+Q3)*DH3**2*MH+SIN(Q2+Q3)*COS(Q2+Q3)*HH3**2*
     + ML-SIN(Q2+Q3)*COS(Q2+Q3)*IH33+SIN(Q2+Q3)*COS(Q2)*H23
     + *DH3*MH+SIN(Q2+Q3)*COS(Q2)*H23*HH3*ML+SIN(Q2)*COS(Q2
     + +Q3)*H23*DH3*MH+SIN(Q2)*COS(Q2+Q3)*H23*HH3*ML+SIN(Q2
     + )*COS(Q2)*H23**2*MH+SIN(Q2)*COS(Q2)*H23**2*ML-SIN(Q2
     + )*COS(Q2)*I233+SIN(Q2)*COS(Q2)*I222+SIN(Q2)*COS(Q2)*
     + D23**2*M2)
      GAM122=-(SIN(Q2+Q3)*DH3*MH*DH1-SIN(Q2+Q3)*IH31
     + +SIN(Q2)*H23*MH*DH1-SIN(Q2)*I231+SIN(Q2)*D21*D23*M2)
      GAM123=-SIN(Q2+Q3)*(DH3*MH*DH1-IH31)
      GAM131=-COS(Q2+Q3)*(SIN(Q2+Q3)*IH22+SIN(Q2+Q3)
     + *DH3**2*MH+SIN(Q2+Q3)*HH3**2*ML-SIN(Q2+Q3)*IH33+SIN(
     + Q2)*H23*DH3*MH+SIN(Q2)*H23*HH3*ML)
      GAM132=-SIN(Q2+Q3)*(DH3*MH*DH1-IH31)
      GAM133=-SIN(Q2+Q3)*(DH3*MH*DH1-IH31)
      GAM211=SIN(Q2+Q3)*COS(Q2+Q3)*IH22+SIN(Q2+Q3)*
     + COS(Q2+Q3)*DH3**2*MH+SIN(Q2+Q3)*COS(Q2+Q3)*HH3**2*ML
     + -SIN(Q2+Q3)*COS(Q2+Q3)*IH33+SIN(Q2+Q3)*COS(Q2)*H23*
     + DH3*MH+SIN(Q2+Q3)*COS(Q2)*H23*HH3*ML+SIN(Q2)*COS(Q2+
     + Q3)*H23*DH3*MH+SIN(Q2)*COS(Q2+Q3)*H23*HH3*ML+SIN(Q2)
     + *COS(Q2)*H23**2*MH+SIN(Q2)*COS(Q2)*H23**2*ML-SIN(Q2)
     + *COS(Q2)*I233+SIN(Q2)*COS(Q2)*I222+SIN(Q2)*COS(Q2)*
     + D23**2*M2
      GAM212=0.0D0
      GAM213=0.0D0
      GAM221=0.0D0
      GAM222=0.0D0
      GAM223=SIN(Q3)*H23*(DH3*MH+HH3*ML)
      GAM231=0.0D0
      GAM232=SIN(Q3)*H23*(DH3*MH+HH3*ML)
      GAM233=SIN(Q3)*H23*(DH3*MH+HH3*ML)
      GAM311=COS(Q2+Q3)*(SIN(Q2+Q3)*IH22+SIN(Q2+Q3)*
     + DH3**2*MH+SIN(Q2+Q3)*HH3**2*ML-SIN(Q2+Q3)*IH33+SIN(
     + Q2)*H23*DH3*MH+SIN(Q2)*H23*HH3*ML)
      GAM312=0.0D0
      GAM313=0.0D0
      GAM321=0.0D0
      GAM322=-SIN(Q3)*H23*(DH3*MH+HH3*ML)
      GAM323=0.0D0
      GAM331=0.0D0
      GAM332=0.0D0
      GAM333=0.0D0
      GRAV1=0.0D0
      GRAV2=G*(SIN(Q2)*COS(Q3)*DH3*MH+SIN(Q2)*COS(Q3)
     + *HH3*ML+SIN(Q2)*H23*MH+SIN(Q2)*H23*ML+SIN(Q2)*D23*M2
     + +SIN(Q3)*COS(Q2)*DH3*MH+SIN(Q3)*COS(Q2)*HH3*ML)
      GRAV3=SIN(Q2+Q3)*G*(DH3*MH+HH3*ML)
      rhs1 = gam111*qd1*qd1
     +        +gam112*qd1*qd2
     +        +gam113*qd1*qd3
     +        +gam121*qd2*qd1
     +        +gam122*qd2*qd2
     +        +gam123*qd2*qd3
     +        +gam131*qd3*qd1
     +        +gam132*qd3*qd2
     +        +gam133*qd3*qd3
     +        +grav1 + fgen1
      rhs2 = gam211*qd1*qd1
     +        +gam212*qd1*qd2
     +        +gam213*qd1*qd3
     +        +gam221*qd2*qd1
     +        +gam222*qd2*qd2
     +        +gam223*qd2*qd3
     +        +gam231*qd3*qd1
     +        +gam232*qd3*qd2
     +        +gam233*qd3*qd3
     +        +grav2 + fgen2
      rhs3 = gam311*qd1*qd1
     +        +gam312*qd1*qd2
     +        +gam313*qd1*qd3
     +        +gam321*qd2*qd1
     +        +gam322*qd2*qd2
     +        +gam323*qd2*qd3
     +        +gam331*qd3*qd1
     +        +gam332*qd3*qd2
     +        +gam333*qd3*qd3
     +        +grav3 + fgen3
      D=J11*J22*J33 + J21*J32*J13 + J31*J12*J23
     /   - J31*J22*J13 - J11*J32*J23 - J21*J12*J33
      JI11=(J22*J33-J23*J32)/D
      JI12=-(J12*J33-J13*J32)/D
      JI13=(J12*J23-J13*J22)/D
      JI21=-(J21*J33-J23*J31)/D
      JI22=(J11*J33-J13*J31)/D
      JI23=-(J11*J23-J13*J21)/D
      JI31=(J21*J32-J22*J31)/D
      JI32=-(J11*J32-J12*J31)/D
      JI33=(J11*J22-J12*J21)/D
      QP1=JI11*RHS1 + JI12*RHS2 + JI13*RHS3
C
*     FUNCTION QP2
      QP2=JI21*RHS1 + JI22*RHS2 + JI23*RHS3
C
*     FUNCTION QP3
      QP3=JI31*RHS1 + JI32*RHS2 + JI33*RHS3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION QD10
      QD10 = 0
C
*     FUNCTION QD20
      QD20 = 0
C
*     FUNCTION QD30
      QD30 = 0
C
*     FUNCTION Q10
      Q10 = 0
C
*     FUNCTION Q20
      Q20 = 0
C
*     FUNCTION Q30
      Q30 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1 = Q1
C
*     FUNCTION FIT2
      FIT2 = Q2
C
*     FUNCTION FIT3
      FIT3 = Q3
C
*     FUNCTION FIT4
      FIT4 = QD1
C
*     FUNCTION FIT5
      FIT5 = QD2
C
*     FUNCTION FIT6
      FIT6 = QD3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
