C-----------------------------------------------------
C
C     Problem:  ROBERT
C
C     Date:     20.10.1993
C
C-----------------------------------------------------
C
*     REAL CONSTANT
      S2=1.0E+4
      S3=1.0E+7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, Y1, Y2, Y3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = -K1*Y1 + S2*K2*Y2*Y3
C
*     FUNCTION Y2P
      Y2P = K1*Y1 - S2*K2*Y2*Y3 - S3*K3*Y2**2
C
*     FUNCTION Y3P
      Y3P = S3*K3*Y2**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 1.0
C
*     FUNCTION Y20
      Y20 = 0.0
C
*     FUNCTION Y30
      Y30 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
*     FUNCTION Y2FIT
      Y2FIT = Y2
C
*     FUNCTION Y3FIT
      Y3FIT = Y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

