C
C------------------------------------------------------
C
C     Problem:    RIE_LD
C
C     Date:       9.12.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      gamma, rho, m, E, rho_x, m_x, E_x, rho_xx, m_xx, E_xx, 
     /       frho, fm, fE, frho_x, fm_x, fE_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_rho
      flux_rho = -m
C
*     FUNCTION flux_m
      if (rho.ne.0) then
        u = m/rho
      else
        u = 1
      endif
      P = (gamma - 1)*(E - 0.5*rho*u**2)
      flux_m = -(rho*u**2 + P)
C
*     FUNCTION flux_E
      flux_E = -u*(E + rho)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION rho_t
      rho_t = frho_x
C
*     FUNCTION m_t
      m_t = fm_x
C
*     FUNCTION E_t
      E_t = fE_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION rho_0
      rho_0 = 1
C
*     FUNCTION m_0
      if (x.lt.0.5) then
        u_0 = -0.1
      else
        u_0 = 0.1
      endif
      m_0 = rho_0*u_0
C
*     FUNCTION E_0
      P_0 = 0.4
      E_0 = P_0/(gamma-1) + 0.5*rho_0*u_0**2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v1_t
c      v1_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v1_0
c      v1_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION rho_right
      rho_right = 1
C
*     FUNCTION m_x_right
      u_right = -1
      m_x_right = rho_right*u_right
C
*     FUNCTION E_x_right
      P_right = 0.4
      E_x_right = P_right/(gamma-1) + 0.5*rho_right*u_right**2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_rho
      fit_rho = rho
C
*     FUNCTION fit_P
      if (rho.ne.0) then
        u = m/rho
      else
        u = 0
      endif
      fit_P = (gamma - 1)*(E - 0.5*rho*u**2)
C
*     FUNCTION fit_u
      if (rho.ne.0) then
        u = m/rho
      else
        u = 0
      endif
      fit_u = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


