C
C------------------------------------------------------
C
C     Problem:    RICH_PT
C
C     Date:       15.12.2003
C
C------------------------------------------------------
C     
*     LININT h
      0.0    -15.0
      40.0  -120.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential algebraic equations, first
C        the differential, then the algebraic variables (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Tsat, Tres, Ksat, alpha, m
      psi, psi_z, psi_zz, out
      f, f_z, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      if (psi.lt.-0.0001) then                                                                          
        w = -alpha*psi
        wm1 = w**(m-1)
        wm = w**m
        K = Ksat*(1 - wm1*(1 + wm)**((1-m)/m))**2/(1 + wm)**((1-m)/(2*m))
        flux = K*(psi_z - 1)
      else
        flux = 0
      endif   
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION psi_t
      if (psi.lt.-0.0001) then                                                                          
        w = -alpha*psi
        wm = w**m 
        wm1 = w**(m-1)
        psi_t = f_z*(1 + wm)**(-1/m)/((m-1)*(Tsat-Tres)*alpha*wm1) 
      else
        psi_t = 0
      endif   
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION psi_0
      psi_0 = -15
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential algebraic equations,
C     first the differential ones in the order given by 
C     increasing spatial positions, then the algebraic ones
C     ones coupled at increasing spatial positions:
C
*     FUNCTION out_t
      out_t = -f
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential algebraic equations at t=0,
C     first for the differential equations in the order
C     given by increasing spatial positions, then for the 
C     algebraic ones ones coupled at increasing spatial 
C     positions:
C
*     FUNCTION out_0
      out_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION psi_right
      psi_right = h(t)
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION psi_z_left  
      psi_z_left = 1
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_psi
      fit_psi = psi
C
*     FUNCTION fit_out
      fit_out = out
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
