C
C------------------------------------------------------
C
C     Problem: RICH_EQU
C  
C     Date: 21.07.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 0.001 
      theta_s = 0.04
C
C------------------------------------------------------
C
*     LININT aw 
      15.0 -15.0
      40.0 -12.5
      70.0 -11.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C    
*     VARIABLE
      theta_r, alpha, n, Ks
      u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      IF (u.LT.0) THEN
        a = -alpha*u
        flux = Ks/(1 + a**n)**((1-1/n)/2)*
     /         (1 - (a**n/(1 + a**n))**(1-1/n))**2
      ELSE
        flux = Ks
      ENDIF
C            
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_p
      IF (u.LT.0.0) THEN
        a = -alpha*u
        C = (theta_s - theta_r)*(n - 1)*(1 + a**n)**(1/n-2)
     /                                      *alpha*a**(n-1)
        G_x = f_x
        G = f
      ELSE
        C = eps
        G_x = 0.0
        G = f
      ENDIF
      u_p = (G_x*u_x + G*u_xx + G_x)/C
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u0
      u0 = aw(x)          
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION u_left
      u_left = -15 - 2*t
C
*     FUNCTION u_right
      u_right = -11 - 2.5*t     
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = u  
C
*     FUNCTION fit2
      fit2 = u  
C
*     FUNCTION fit3
      fit3 = u  
C
*     FUNCTION fit4
      fit4 = u  
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

