C
C------------------------------------------------------
C
C     Problem:    RE_ENTRY
C
C     Date:       28.03.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      RE = 6378.0
      G0 = 9.8065E-3
      RHO0 = 1.25E+9
      BETA1 = 6.9
      C1 = -0.505
      C2 = 0.88
      C3 = 0.52
      MS = 3.0E+8 
      PI = 3.141592654
C
C------------------------------------------------------
C
*     MACRO ALPHA_T
      ALPHA_T = CA1 + CA2*1.0E-2*T + CA3*1.0E-4*T**2 
     /        + CA4*1.0E-6*T**3 
     /        + CA5*1.0E-8*T**4
     /        + CA6*1.0E-10*T**5 
     /        + CA7*1.0E-12*T**6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CA1, CA2, CA3, CA4, CA5, CA6, CA7, PSI, ZETA, V
      GAMMA, Q, KAPPA, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION PSIP
      H = ZETA*RE
      R = RE + H
      PSIP = V/R*COS(GAMMA)
C
*     FUNCTION ZETAP
      ZETAP = V/RE*SIN(GAMMA)
C
*     FUNCTION VP
      ALPHA = ALPHA_T*PI/180.0
      CD = C2 + C3*COS(ALPHA)
      RHO = RHO0*EXP(-H/BETA1)
      VP = -0.5*RHO*V**2/MS*CD - G0/(1+ZETA)**2*SIN(GAMMA)
C
*     FUNCTION GAMMAP
      CL = C1*SIN(ALPHA)
      GAMMAP = -0.5*RHO*V/MS*CL + (V/(RE*(1+ZETA)) 
     /           - G0/(V*(1+ZETA)**2))*COS(GAMMA)
C
*     FUNCTION QP
      QP = SQRT(RHO)*V**3
C
*     FUNCTION KAPPAP
      IF (GAMMA.GT.0) THEN
         KAPPAP = -GAMMA
      ELSE
         KAPPAP = 0.0
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PSI0
      PSI0 = 0.0 
C
*     FUNCTION ZETA0
      ZETA0 = 122.0/RE
C
*     FUNCTION V0
      V0 = 10.5
C
*     FUNCTION GAMMA0
      GAMMA0 = -0.1
C
*     FUNCTION Q0
      Q0 = 0.0
C
*     FUNCTION KAPPA0
      KAPPA0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION GAMMAFIT
      GAMMAFIT = GAMMA
C
*     FUNCTION PSIFIT
      PSIFIT = PSI
C
*     FUNCTION ZETAFIT
      ZETAFIT = ZETA
C
*     FUNCTION VFIT
      VFIT = V
C
*     FUNCTION QFIT
      QFIT = Q
C
*     FUNCTION KAPPAFIT
      KAPPAFIT = KAPPA
C
*     FUNCTION ALPHAF
      ALPHAF = ALPHA_T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
