C
C------------------------------------------------------
C
C     Problem:    REXT
C
C     Date:       24.01.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      F0=100         
      ca0=0.9        
      F3=20          
      cp30=0.05     
      Vr=1000        
      Vx=200         
      Vy=100        
      k1=0.7        
      ki=0.3        
      m=2            
      Ka=1           
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      R, tau, ca1, cp1, ca2, cp2, cp3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ca1_t
      ra=-k1*ca1/(1+cp1/ki) 
      rp=-ra
      ref=R
      if (t.gt.tau) then
        ref=0
      endif
      ca1_t=(F0*ca0+ref*F0*ca2-(1+ref)*F0*ca1)/Vr+ra
C
*     FUNCTION cp1_t
      cp1_t=(ref*F0*cp2-(1+ref)*F0*cp1)/Vr+rp
C
*     FUNCTION ca2_t
      Ve=Vx+Vy
      cp3s=m*cp2
      ca2_t=((1+ref)*F0*ca1-F0*ca2-ref*F0*ca2)/Vx
C
*     FUNCTION cp2_t
      cp2_t=((1+ref)*F0*cp1-ref*F0*cp2-F0*cp2-Ka*Ve*(cp3s-cp3))/Vx
C
*     FUNCTION cp3_t
      cp3_t=(F3*cp30-F3*cp3+Ka*Ve*(cp3s-cp3))/Vy
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION ca1_0
      if (t.lt.tau) then
        ca1_0 = 0
      else
        ca1_0 = ca1
      endif
C
*     FUNCTION cp1_0
      if (t.lt.tau) then
        cp1_0 = 0
      else
        cp1_0 = cp1
      endif
C
*     FUNCTION ca2_0
      if (t.lt.tau) then
        ca2_0 = 0
      else
        ca2_0 = ca2
      endif
C
*     FUNCTION cp2_0
      if (t.lt.tau) then
        cp2_0 = 0
      else
        cp2_0 = cp2
      endif
C
*     FUNCTION cp3_0
      if (t.lt.tau) then
        cp3_0 = cp30
      else
        cp3_0 = cp3
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ca1_fit
      ca1_fit = ca1
   
C
*     FUNCTION cp1_fit
      cp1_fit = cp1
C
*     FUNCTION ca2_fit
      ca2_fit = ca2
C
*     FUNCTION cp2_fit
      cp2_fit = cp2
C
*     FUNCTION cp3_fit
      cp3_fit = cp3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

