C
C------------------------------------------------------
C
C     Problem:    REVTEMP
C
C     Date:       1.02.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      TST = 298  
      HFAST = -160    
      HFBST = -240    
      KEST = 1000
      AA = 0.100      
      AB = 0.080       
      BA = 0.0006     
      BB = 0.0004     
      EA = 120.0     
      R = 8.314E-3    
      KST = 0.001       
      F = 0.0        
      CA0 = 25e3     
      CB0 = 0.0 
      T10 = 290    
      FC0  = 0.0      
      VC   = 0.1     
      TC0  = 290     
      RHOC = 1000     
      UA   = 2000     
      TIMEON = 1000  
      CAinit = 20e3  
      CBinit = 0     
      T1init = 305    
      TCinit = 305    
      DHRST = HFBST-HFAST       
      DA = AB-AA  
      DB = BB-BA  
      KA1= KST/EXP(-EA/R/TST) 
      FC = FC0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      V, CPC, CA, CB, T1, TC, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CAP
      K1   = KA1*EXP(-EA/(R*T1))  
      DHRST1 = DHRST - DA*TST - DB/2*TST**2   
      LNKE1  = DA/R*LOG(T1/TST)+DB/R*(T1-TST) 
      LNKE = LOG(KEST)-DHRST1/R*(1/T1-1/TST) +LNKE1   
      KE   = EXP(LNKE)
      RA   = -K1*(CA-CB/KE)   
      dCA  = F/V*(CA0-CA) + RA
      dCB  = F/V*(CB0-CB) - RA
      CAP  = dCA  
C
*     FUNCTION CBP
      CBP  = dCB  
C
*     FUNCTION T1P
      CPA    = AA + BA*T1       
      CPB    = AB + BB*T1 
      SUMCP  = V*(CA*CPA + CB*CPB)
      FEEDCP = F*CA0*(AA*(T10-T1) + BA/2*(T10**2 - T1**2))
      DHRT1  = DHRST + DA*(T1-TST) + DB/2*(T1**2 - TST**2)
      DT1    = (FEEDCP + V*RA*DHRT1 + UA*(TC-T1))/SUMCP   
      T1P    = DT1
C
*     FUNCTION TCP
      dTC = FC/VC*(TC0-TC)-UA*(TC-T1)/V/RHOC/CPC  
      TCP = dTC   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA_0
      IF (T.LT.0.001) THEN
        CA_0 = CAINIT  
      ELSE
        CA_0 = CA
      ENDIF
C
*     FUNCTION CB_0
      IF (T.LT.0.001) THEN
        CB_0 = CBINIT  
      ELSE
        CB_0 = CB
      ENDIF
C
*     FUNCTION T1_0
      IF (T.LT.0.001) THEN
        T1_0 = T1INIT  
      ELSE
        T1_0 = T1
      ENDIF
C
*     FUNCTION TC_0
      IF (T.LT.0.001) THEN
        TC_0 = TCINIT  
      ELSE
        TC_0 = TC
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_FIT
      CA_FIT = CA
C
*     FUNCTION CB_FIT
      CB_FIT = CB
C
*     FUNCTION T1_FIT
      T1_FIT = T1
C
*     FUNCTION TC_FIT
      TC_FIT = TC
C
C-----------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
