C
C------------------------------------------------------
C
C     Problem:    RES_TIME
C
C     Date:       29.1.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k1 = 2
      k2 = 1
      k3 = 0.2
      k4 = 0.6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      T, cA, cB, cC, cD, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cA_t
      cA_t = (-k1*cA + k2*cB)*T
C
*     FUNCTION cB_t
      cB_t = (k1*cA - (k2 + k3 + k4)*cB)*T
C
*     FUNCTION cC_t
      cC_t = k3*cB*T
C
*     FUNCTION cD_t
      cD_t = k4*cB*T
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cA_0
      cA_0 = 50
C
*     FUNCTION cB_0
      cB_0 = 5
C
*     FUNCTION cC_0
      cC_0 = 0
C
*     FUNCTION cD_0
      cD_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cB_fit
      cB_fit = cB
C
*     FUNCTION balance
      balance = cA + cB + cC + cD - 55
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
