C
C------------------------------------------------------
C
C     Problem:    RESPIRA
C
C     Date:       30.7.2007
C
C------------------------------------------------------
C        
*     LININT v  
      0.0   0.0
      0.2   0.8
      1.0   0.8
      1.001 0.0
      1.7   0.0
      1.701 -0.55
      2.5   -0.3
      3.0   -0.2
      4.0   -0.06
      5.0   -0.03
C
C------------------------------------------------------
C             
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      E1, E2, R1, R2, P10, P20, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = v(t)
C
*     FUNCTION x2_t
      x2_t = v(t) - E2/R2*x2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0 
      if (t.lt.0.1) then
        x1_0 = P10/E1
      else
        x1_0 = x1
      endif    
C
*     FUNCTION x2_0
      if (t.lt.0.1) then
        x2_0 = P20/E2
      else
        x2_0 = x2
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C               
*     FUNCTION P
      P = E1*x1 + E2*x2 + R1*v(t) 
C
*     FUNCTION V_plot
      V_plot = v(t)
C      
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
