C
C------------------------------------------------------
C
C     Problem:    RESPIR
C
C     Date:       23.11.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      r1, r2, E, v, w, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION v_t
      v_t = w
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ
      s = sin(pi*(t-1))
      c = cos(pi*(t-1))
      p = 1.25*(1 + c) - 1.5*(1 - 3/32*s)*s
      alg_equ = r1*w + r2*w**2 + E*v - p
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION v_0
      v_0 = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION w_0
      w_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION w_fit
      w_fit = w
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

