C
C------------------------------------------------------
C
C     Problem:    REPLCUL
C
C     Date:       03.07.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      VR = 5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      S0, UM, KS, Y, V, VS, VX, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VSP
      S = VS/V
      U = UM*S/(KS + S)
      X = VX/V
      RX = U*X
      RS = -RX/Y
      VSP = RS*V
C
*     FUNCTION VXP
      VXP = RX*V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION VS0
      IF (T.LT.0.001) THEN
        VXF = 3
        VSF = 2
      ELSE
        VXF = VX
        VSF = VS
      ENDIF
      F = VR/V
      VS0 = (1 - F)*VSF + VR*S0
C
*     FUNCTION VX0
      VX0 = (1 - F)*VXF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      XFIT = VX/V
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



