C
C------------------------------------------------------
C
C     Problem:    REPFED
C
C     Date:       03.07.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V00=1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F0, S0, UM, KS, Y, V, VS, VX, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VP
      VP=F0
C
*     FUNCTION VSP
      X=VX/V
      S=VS/V
      U=UM*S/(KS+S)
      RX=U*X
      RS=-RX/Y
      VSP=F0*S0+RS*V
C
*     FUNCTION VXP
      VXP=RX*V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION V0
      V0=V00
C
*     FUNCTION VS0
      IF (T.LT.0.001) THEN
        VF=0.1
        VSF=0.01
        VXF=0.01
      ELSE
        VF=V
        VSF=VS
        VXF=VX
      ENDIF      
      F=V00/VF
      VS0=F*VSF
C
*     FUNCTION VX0
      VX0=F*VXF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION SFIT
      SFIT=VS/V
C
*     FUNCTION VXFIT
      VXFIT=VX
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
