C
C------------------------------------------------------
C
C   Problem:    RELEASE
C
C   Date:       12.12.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S = 2
      m = 0.0546
      Vd = 2
      Cd = 0.0174     
      scale1 = 1.0E-5
      scale2 = 1.0E-5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      P1, P2, tlag1, tlag2, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Ca1
      Ca1 = m*(1-exp(-(P1*scale1*S/Vd)*(t-tlag1)))
C
*     FUNCTION Ca2
      Ca2 = (P2*scale2*S*Cd)*(t-tlag2)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

