C
C------------------------------------------------------
C
C     Problem:    REG_RES
C
C     Date:       21.2.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      m = 0.01
      k = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, d, r, x, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      if (x.lt.a*y) then
        e = x
      else
        e = a*y
      endif
      x_t = r*x*x/k*(1 - x/k) - e + m*k
C
*     FUNCTION y_t
      if (y.eq.0) then
        c = 0
      else
        c = x/y
      endif
      y_t = b*y*c/(c + 1) - d*y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 1
C
*     FUNCTION y_0
      y_0 = 0.01
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
