C
C------------------------------------------------------
C
C     Problem:    REFRIG
C
C     Date:       1.02.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      W=900
C      M=1100
      CA0=0.5
      TEMP0=330
      HR=-1.4E3
      HV=637
      CP= 3.14
      Z=7.08E10
      E=76.2E3
      R=8.314
      S0= 330
      SMAX=1000
C      TSET=360
      KP=30
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      TSET, M, CA, TR, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CAP
      K=Z*EXP(-E/(R*TR))
      S=S0-KP*(TSET-TR)
      IF (S.LE.0) THEN
        S=0
      ENDIF
      IF (S.GT.SMAX) THEN
        S=SMAX
      ENDIF
      CAP= (W*(CA0-CA)-K*CA*M)/M
C
*     FUNCTION TRP
      TRP=(W*CP*(TEMP0-TR)-M*K*CA*(HR)-S*HV)/(M*CP)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA_0
      CA_0 = 0  
C
*     FUNCTION TR_0
      TR_0 = TEMP0 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_FIT
      CA_FIT = CA 
C
*     FUNCTION TR_FIT
      TR_FIT = TR/TEMP0 - 1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
