C
C------------------------------------------------------
C
C     Problem:    REFLECTY
C
C     Date:       14.05.2004
C
C------------------------------------------------------
C       
*     REAL CONSTANT
      mu = 1.130469005513490E-001                     
      t0 = 0.18                                      
      tb = 11.417823202820120 * 0.01745329251994     
      AA = mu * t0 / cos(tb)
      P = (1 + (cos(2*tb))**2)/2
      Fhkl = sqrt(3.536346308456155**2 + (4.58815426260982e-4)**2)*0.968
      r0 = 2.81794092e-13                             
      lambda = 7.09338062818239e-9                   
      V = 1.62253546981499e-23
      r0liV = r0*lambda/V
      pi = 3.1415926535 
C      
C------------------------------------------------------
C       
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      eta, tc, x
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION R
      W = 1/(sqrt(2*pi)*eta)*exp( -x**2/(2.*eta**2))
      Y = tc/sin(tb)*Fhkl*r0liV
      f = (tanh(Y) + abs(cos(2*tb))*tanh(abs(Y*cos(2*tb))))/(Y*(1 + (cos(2*tb))**2))
      Q = (r0*Fhkl/V)**2*(lambda**3/sin(2*tb))*P*f
      a = W*Q/mu
      R = sinh(AA*a)*exp(-AA*(1 + a))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
