C
C------------------------------------------------------
C
C     Problem:    REFLECT
C
C     Date:       24.7.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      d = 2
      mB = 100
      r0 = 0
      r1 = 0.6
      sc = 10000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      kB, kW, kS, sB, sW, sS, mS, mW
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION R_1
      M = mB + mW + mS
      cB = mB/M
      cW = mW/M
      cS = mS/M
      K = d*(cB*kB + cW*kW + cS*kS)
      S = d*(cB*sB*sc + cW*sW*sc + cS*sS)
      tau0 = K + 2*S
      omega0 = 2*S/(K + 2*S)
      gamma = sqrt(1 - omega0)
      x = 2*gamma*tau0
      if (abs(x).lt.0.01) then
        Q = 1 - x/2
      else
        Q = (1 - exp(-x))/x
      endif
      Rinf = (1 - gamma)/(1 + gamma)
      QR = 2*tau0*Q
      Ru = 0.8909
      Rg = (Ru - r0)/((1 - r0)*(1 - r1) + r1*(Ru - r0))
      R_1 = r0 + (1-r0)*(1-r1)*(Rg*(1+Rinf)**2 + (Rinf-Rg)*QR)/
     /    ((1-r1*Rg)*(1+Rinf)**2 + (Rinf-r1)*(Rinf-Rg)*QR)
C
*     FUNCTION R_2
      Ru = 0.257
      Rg = (Ru - r0)/((1 - r0)*(1 - r1) + r1*(Ru - r0))
      R_2 = r0 + (1-r0)*(1-r1)*(Rg*(1+Rinf)**2 + (Rinf-Rg)*QR)/
     /    ((1-r1*Rg)*(1+Rinf)**2 + (Rinf-r1)*(Rinf-Rg)*QR)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


