C
C------------------------------------------------------
C
C     Problem:    REAC_CTR
C
C     Date:       31.05.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..20
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k10 = 1.7536
      k20 = 2.4885
      e1 = 1.1375
      e2 = 2.2748
      r = 1.9872
      a = 300
      Temp0 = 290
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a0, a1, a2, a3, c, Temp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION c_t
      k1 = k10*1E5*exp(-e1*1E4/(r*Temp))
      k2 = k20*1E10*exp(-e2*1E4/(r*Temp))
      cp = (1 - c)*k1 - c*k2
      c_t = cp
C
*     FUNCTION Temp_t
      u = a0 + a1*t + a2*t**2 + a3*t**3
      Temp_t = a*cp - u*(Temp - Temp0)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c_0
      c_0 = 0
C
*     FUNCTION Temp_0
      Temp_0 = 380
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION Temp_fit
      Temp_fit = Temp
C
*     FUNCTION ctrl
      u = a0 + a1*t + a2*t**2 + a3*t**3 
      ctrl = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(i), i in ind
      g(i) = 460 - Temp 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



