C
C------------------------------------------------------
C
C     Problem:    REACTION
C
C     Date:       30.06.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k7 = 12
      k8 = 0.8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, k6, Y, S, B, F, D, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dY_dt
      w = F/k8
      dY_dt = k2*S + k5*B*w - k1*Y*(k7 - w) - k3*Y*w
C
*     FUNCTION dS_dt
      dS_dt = -k2*S + k1*Y*(k7 - w)
C
*     FUNCTION dB_dt
      dB_dt = k3*Y*w + k4*D*w
C
*     FUNCTION dF_dt
      dF_dt = -k6*(Y + B + D)*w
C
*     FUNCTION dD_dt      
      dD_dt = k5*B*w - k4*D*w
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y0
      Y0 = 0
C
*     FUNCTION S0
      S0 = 100
C
*     FUNCTION B0
      B0 = 0
C
*     FUNCTION F0
      F0 = 1
C
*     FUNCTION D0
      D0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Yest
      Yest = Y + B + D
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



