C
C------------------------------------------------------
C
C     Problem:    COLLISIO
C
C     Date:       30.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s1 = 1e-6
      s2 = 1e3
      s3 = 1e14
      s4 = 1e9
      s5 = 1e7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      sk1, sk2, sk3, sk4, sk5, y1, y2, y3, y4, y5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      k1 = s1*sk1
      k2 = s2*sk2
      k3 = s3*sk3
      k4 = s4*sk4
      k5 = s5*sk5
      g1 = k1*y1
      g2 = k2*y3*y2
      g3 = k3*y1*y5
      g4 = k4*y4*y5
      g5 = k5*y2*y2
      y1_t = -g1 - g3 + g5
C
*     FUNCTION y2_t
      y2_t = -g2 - 2*g5 + 2*g1 + g3 + g4
C
*     FUNCTION y3_t
      y3_t = -g2 + g4
C
*     FUNCTION y4_t
      y4_t = -g4 + g2 + g3
C
*     FUNCTION y5_t
      y5_t = -g3 - g4 + g2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 1
C
*     FUNCTION y4_0
      y4_0 = 0
C
*     FUNCTION y5_0
      y5_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


