C
C------------------------------------------------------
C
C     Problem:    REAC
C
C     Date:       13.02.00
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10
      ind1 = 2..7
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F1=5.00E-04
      F2=3.50E-01
      F3=1.00E+00
      F4=1.00E-03
c      Ph=1.d-3
      CL25=569.0d0
      CL26=1000.0d0
c      kl1=Ph
      A5=64.366272d0
      B5=-6955.958d0
      CC5=-5.802231d0
      D5=3.11493d-9
      EE5=3.0d0
      A55=0.0d0
      A56=2.54d0
      A65=-1.022d0
      A66=0.0d0
      B55=0.0d0
      B56=784.3d0
      B65=136.35d0
      B66=0.0d0
      alph55=0.2d0
      alph56=0.2d0
      alph65=0.2d0
      alph66=0.2d0
      Tau55=0.0d0
      Tau66=0.0d0
      E25=0.0d0
      Temp=378.0d0
      Gcon=8.314d0
      A6=92.291936d0
      B6=-9151.436d0
      CC6=-9.612852d0
      D6=3.8415d-18
      EE6=6.0d0
      E36=0.0d0
c      ka8=Ph
      CL75=99.59d0
      CL76=1968d0
c      kl10=Ph
      NA8=0.0d0
      NA9=0.0d0
      Vg=1d0
      Tref=0.0000001
      T0=60.0d0
      T1=60.5d0
      PI=3.14159265d0
C
C------------------------------------------------------
C
*     TABLE molm(i), i in ind
      1  0.1941387d0
      2  0.1941387d0
      3  0.25024646d0
      4  0.098d0
      5  0.0741227d0
      6  0.01801494d0
      7  0.17612376d0
      8  0.0741227d0
      9  0.01801494d0
      10 0.17612376d0
C
*     TABLE rho(i), i in ind
      1  1600d0
      2  1600d0
      3  990d0
      4  1841d0
      5  809.8d0
      6  1000d0
      7  1650d0
      8  1650d0
      9  1650d0
      10 1650d0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ph, Y01, Y05
      Y(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1_t
      kl1=Ph
      kl10=Ph
      ka10=Ph
      ka8=Ph
      V1=molm(1)/rho(1)
      V2=sum(Y(i)*molm(i)/rho(i), i in ind1)
      C2=Y(2)/V2
      CL2=CL25*Y(5)/(Y(5) + Y(6)) + CL26*Y(6)/(Y(5) + Y(6))
      Y1_t=-kl1*(CL2 - C2)
C
*     FUNCTION Y2_t
      C3=Y(3)/V2
      C5=Y(5)/V2
      C6=Y(6)/V2
      C4=Y(4)/V2
      r3=F1*C4*C2*C5
      r4=F2*C3*C6
      r5=F3*C2*C4
      Y2_t=kl1*(CL2 - C2) + (-r3 + r4 - r5)*V2
C
*     FUNCTION Y3_t
      r6=F4*C3*C4
      Y3_t=(r3 - r4 - r6)*V2
C
*     FUNCTION Y4_t
      Y4_t=(0.01d0/PI)*(ATAN((T-T0)/Tref) + ATAN((T1-T)/Tref))
C
*     FUNCTION Y5_t
      SumY=sum(Y(i), i in ind1)
      X5=Y(5)/SumY
      X6=Y(6)/SumY
      PS5=DEXP(A5+B5/Temp+CC5*DLOG(Temp)+D5*DEXP(EE5*DLOG(Temp)))
      Tau56=A56 + B56/Temp
      Tau65=A65 + B65/Temp
      P55=1.0
      P56=EXP(-alph56*Tau56)
      P65=EXP(-alph65*Tau65)
      P66=1.0
      S15=X5*P55*Tau55 + X6*P65*Tau65
      S25=X5*P55 + X6*P65
      S16=X5*P56*Tau56 + X6*P66*Tau66
      S26=X5*P56 + X6*P66
      Sum1=X5*(P55/S25)*(Tau55 - S15/S25)
      Sum2=X6*(P56/S26)*(Tau56 - S16/S26)
      gamma5=EXP(S15/S25 + Sum1 + Sum2)
      IF (Y(8)+Y(9).LE.1.0d-10) THEN
        Yps8=0.0d0
      ELSE
        Yps8=Y(8)/(Y(8)+Y(9))
      ENDIF
      PS6=DEXP(A6+B6/Temp+CC6*LOG(Temp)+D6*EXP(EE6*LOG(Temp)))
      gamma6=EXP(S16/S26 + Sum1 + Sum2)
      Pges=X5*gamma5*PS5 + X6*gamma6*PS6
      Sum3=(-r3+r4+r6)*V2
      Y5_t=E25 - (ka10/(Gcon*Temp))
     /                *(PS5*gamma5*X5 - Yps8*Pges) + Sum3
C
*     FUNCTION Y6_t
      Sum1=(X5/S25)*(Tau65 - S15/S25)
      Sum2=(X6/S26)*(Tau66 - S16/S26)
      IF ((Y(8)+Y(9)).LE.1d-10) THEN
        Yps9=0.0d0
      ELSE
        Yps9=Y(9)/(Y(8) + Y(9))
      ENDIF
      Sum3=(r3 - r4 + r5)*V2
      Y6_t=E36 - (ka8/(Gcon*Temp))*(PS6*gamma6*X6 - Yps9*Pges)
     /         + Sum3
C
*     FUNCTION Y7_t
      C7=Y(7)/V2
      CL7=(CL75*Y(5)/(Y(5) + Y(6)) + CL76*Y(6)/(Y(5) +Y(6)))
      Y7_t=kl10*(CL7 - C7) + (r5 + r6)*V2
C
*     FUNCTION Y8_t
      Y8_t=-NA8 + (ka10/(Gcon*Temp))*(PS5*gamma5*X5 - Yps8*Pges)
C
*     FUNCTION Y9_t
      Y9_t=-NA9 + (ka8/(Gcon*Temp))*(PS6*gamma6*X6 - Yps9*Pges)
C
*     FUNCTION Y10_t
      Y10_t=-kl10*(CL7 - C7)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y0(i), i in ind
      if (i.eq.1) then
        Y0(i) = Y01
      else
        if (i.eq.5) then
          Y0(i) = Y05
        else
          Y0(i) = 0
        endif
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y_fit(i), i in ind
      Y_fit(i) = Y(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
